/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.database;

import de.digitalcollections.model.api.filter.FilterCriterion;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.filter.enums.FilterOperation;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractPagingAndSortingRepositoryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPagingAndSortingRepositoryImpl.class);

    public void addFiltering(Filtering filtering, StringBuilder sqlQuery) {
        String filterClauses;
        if (filtering != null && !(filterClauses = this.getFilterClauses(filtering)).isEmpty()) {
            String innerQueryStr = sqlQuery.toString();
            if (innerQueryStr.toUpperCase().contains(" WHERE ")) {
                sqlQuery.append(" AND ");
            } else {
                sqlQuery.append(" WHERE ");
            }
            sqlQuery.append(filterClauses);
        }
    }

    public void addFiltering(PageRequest pageRequest, StringBuilder sqlQuery) {
        if (pageRequest != null) {
            this.addFiltering(pageRequest.getFiltering(), sqlQuery);
        }
    }

    public void addLimit(PageRequest pageRequest, StringBuilder sqlQuery) {
        int pageSize;
        if (pageRequest != null && (pageSize = pageRequest.getPageSize()) > 0) {
            sqlQuery.append(" ").append("LIMIT").append(" ").append(pageSize);
        }
    }

    public void addOffset(PageRequest pageRequest, StringBuilder sqlQuery) {
        int offset;
        if (pageRequest != null && (offset = pageRequest.getOffset()) >= 0) {
            sqlQuery.append(" ").append("OFFSET").append(" ").append(offset);
        }
    }

    public void addOrderBy(PageRequest pageRequest, StringBuilder sqlQuery) {
        if (pageRequest != null) {
            String orderBy;
            List<String> allowedOrderByFields = this.getAllowedOrderByFields();
            Sorting sorting = pageRequest.getSorting();
            if (sorting != null && StringUtils.hasText((String)(orderBy = Optional.ofNullable(sorting.getOrders()).orElse(Collections.emptyList()).stream().filter(o -> {
                boolean allowedSortField;
                String sortField = o.getProperty();
                boolean bl = allowedSortField = sortField != null && allowedOrderByFields != null && allowedOrderByFields.contains(sortField);
                if (!allowedSortField) {
                    LOGGER.warn("'" + sortField + "' not in allowed sort fields! Ignoring it.");
                }
                return allowedSortField;
            }).map(o -> {
                String sortDirection = null;
                Direction direction = o.getDirection();
                sortDirection = direction != null && direction.isDescending() ? "DESC" : "ASC";
                String sortField = o.getProperty();
                Optional subSortField = o.getSubProperty();
                String fullQualifiedColumnName = this.getColumnName(sortField);
                if (subSortField.isEmpty()) {
                    return String.format("%s %s", fullQualifiedColumnName, sortDirection);
                }
                return String.format("%s->>'%s' %s", fullQualifiedColumnName, subSortField.get(), sortDirection);
            }).collect(Collectors.joining(","))))) {
                sqlQuery.append(" ORDER BY ").append(orderBy);
            }
        }
    }

    protected void addPageRequestParams(PageRequest pageRequest, StringBuilder sqlQuery) {
        if (pageRequest != null) {
            this.addOrderBy(pageRequest, sqlQuery);
            this.addLimit(pageRequest, sqlQuery);
            this.addOffset(pageRequest, sqlQuery);
        }
    }

    protected String convertToSqlString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof LocalDate) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return "'" + ((ChronoLocalDate)value).format(formatter) + "'";
        }
        if (value instanceof String) {
            return "'" + value + "'";
        }
        return value.toString();
    }

    protected abstract List<String> getAllowedOrderByFields();

    protected abstract String getColumnName(String var1);

    protected String getFilterClauses(Filtering filtering) {
        if (filtering == null || filtering.getFilterCriteria().isEmpty()) {
            return "";
        }
        String filterClauses = filtering.getFilterCriteria().stream().map(this::getWhereClause).collect(Collectors.joining(" AND "));
        return filterClauses;
    }

    protected String getWhereClause(FilterCriterion<?> fc) throws IllegalArgumentException, UnsupportedOperationException {
        StringBuilder query = new StringBuilder();
        if (fc != null) {
            String leftSide;
            FilterOperation filterOperation = fc.getOperation();
            String fieldName = fc.getFieldName();
            String columnName = this.getColumnName(fieldName);
            String string = leftSide = columnName != null ? columnName : fieldName;
            if (leftSide.contains(" ") || leftSide.contains(";")) {
                throw new IllegalArgumentException(String.format("leftSide '%s' seems to contain malicious code!", leftSide));
            }
            switch (filterOperation) {
                case BETWEEN: {
                    if (fc.getMinValue() == null || fc.getMaxValue() == null) {
                        throw new IllegalArgumentException("For 'BETWEEN' operation two values are expected");
                    }
                    query.append("(").append(leftSide).append(" BETWEEN ").append(this.convertToSqlString(fc.getMinValue())).append(" AND ").append(this.convertToSqlString(fc.getMaxValue())).append(")");
                    break;
                }
                case IN: 
                case NOT_IN: {
                    query.append("(").append(leftSide);
                    if (filterOperation == FilterOperation.NOT_IN) {
                        query.append(" NOT");
                    }
                    query.append(" IN (");
                    query.append(fc.getValues().stream().map(this::convertToSqlString).collect(Collectors.joining(",")));
                    query.append("))");
                    break;
                }
                case CONTAINS: {
                    query.append("(").append(leftSide).append(" ILIKE '%").append(this.convertToSqlString(fc.getValue())).append("%')");
                    break;
                }
                case STARTS_WITH: {
                    query.append("(").append(leftSide).append(" ILIKE ").append(this.convertToSqlString(fc.getValue())).append(" || '%')");
                    break;
                }
                case EQUALS: {
                    query.append("(").append(leftSide).append(" = ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case NOT_EQUALS: {
                    query.append("(").append(leftSide).append(" != ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case GREATER_THAN: {
                    query.append("(").append(leftSide).append(" > ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case GREATER_THAN_OR_NOT_SET: {
                    query.append("(").append(leftSide).append(" > ").append(this.convertToSqlString(fc.getValue())).append(" OR ").append(leftSide).append(" IS NULL").append(")");
                    break;
                }
                case GREATER_THAN_OR_EQUAL_TO: {
                    query.append("(").append(leftSide).append(" >= ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case LESS_THAN: {
                    query.append("(").append(leftSide).append(" < ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case LESS_THAN_AND_SET: {
                    query.append("(").append(leftSide).append(" < ").append(this.convertToSqlString(fc.getValue())).append(" AND ").append(leftSide).append(" IS NOT NULL").append(")");
                    break;
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    query.append("(").append(leftSide).append(" <= ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case LESS_THAN_OR_EQUAL_TO_AND_SET: {
                    query.append("(").append(leftSide).append(" <= ").append(this.convertToSqlString(fc.getValue())).append(" AND ").append(leftSide).append(" IS NOT NULL").append(")");
                    break;
                }
                case LESS_THAN_OR_EQUAL_TO_OR_NOT_SET: {
                    query.append("(").append(leftSide).append(" <= ").append(this.convertToSqlString(fc.getValue())).append(" OR ").append(leftSide).append(" IS NULL").append(")");
                    break;
                }
                case SET: {
                    query.append("(").append(leftSide).append(" IS NOT NULL").append(")");
                    break;
                }
                case NOT_SET: {
                    query.append("(").append(leftSide).append(" IS NULL").append(")");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(filterOperation + " not supported yet");
                }
            }
        }
        return query.toString();
    }
}

