/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.SubtopicRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts.EntityPartRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.Topic;
import de.digitalcollections.model.api.identifiable.entity.parts.Subtopic;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.NodeImpl;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import de.digitalcollections.model.impl.identifiable.entity.TopicImpl;
import de.digitalcollections.model.impl.identifiable.entity.parts.SubtopicImpl;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import de.digitalcollections.model.impl.view.BreadcrumbNavigationImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SubtopicRepositoryImpl
extends EntityPartRepositoryImpl<Subtopic, Entity>
implements SubtopicRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubtopicRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT s.uuid s_uuid, s.label s_label, s.description s_description, s.identifiable_type s_type, s.created s_created, s.last_modified s_lastModified, s.preview_hints s_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM subtopics as s LEFT JOIN identifiers as id on s.uuid = id.identifiable LEFT JOIN fileresources_image as file on s.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT s.uuid s_uuid, s.label s_label, s.description s_description, s.identifiable_type s_type, s.created s_created, s.last_modified s_lastModified, s.preview_hints s_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM subtopics as s LEFT JOIN fileresources_image as file on s.previewfileresource = file.uuid";
    private static final String BASE_CHILDREN_QUERY = "SELECT s.uuid s_uuid, s.label s_label, s.description s_description, s.identifiable_type s_type, s.created s_created, s.last_modified s_lastModified, s.preview_hints s_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM subtopics as s INNER JOIN subtopic_subtopics ss ON s.uuid = ss.child_subtopic_uuid LEFT JOIN fileresources_image as file on s.previewfileresource = file.uuid WHERE ss.parent_subtopic_uuid = :uuid";
    private static final String BREADCRUMB_QUERY = "WITH recursive breadcrumb (uuid,label,parent_uuid,depth) AS (        SELECT s.uuid as uuid, s.label as label, ss.parent_subtopic_uuid as parent_uuid,99 as depth        FROM subtopics s, subtopic_subtopics ss        WHERE uuid= :uuid and ss.child_subtopic_uuid = s.uuid        UNION ALL        SELECT s.uuid as uuid, s.label as label, ss.parent_subtopic_uuid as parent_uuid, depth-1 as depth        FROM subtopics s,             subtopic_subtopics ss,             breadcrumb b        WHERE b.uuid = ss.child_subtopic_uuid and ss.parent_subtopic_uuid = s.uuid AND ss.parent_subtopic_uuid is not null    ) SELECT * from breadcrumb UNION SELECT null as uuid, t.label as label, null as parent_uuid, 0 as depth FROM topics t, topic_subtopics ts, breadcrumb b WHERE ts.subtopic_uuid = b.parent_uuid and t.uuid = ts.topic_uuid ORDER BY depth ASC";
    private static final String BREADCRUMB_WITHOUT_PARENT_QUERY = "SELECT s.uuid as uuid, s.label as label        FROM subtopics s        WHERE uuid= :uuid";

    @Autowired
    public SubtopicRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM subtopics";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<Subtopic> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(SubtopicImpl.class, (String)"s"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            SubtopicImpl subtopic = map.computeIfAbsent((UUID)rowView.getColumn("s_uuid", UUID.class), fn -> (SubtopicImpl)rowView.getRow(SubtopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                subtopic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Subtopic findOne(UUID uuid) {
        String query = "SELECT s.uuid s_uuid, s.label s_label, s.description s_description, s.identifiable_type s_type, s.created s_created, s.last_modified s_lastModified, s.preview_hints s_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM subtopics as s LEFT JOIN identifiers as id on s.uuid = id.identifiable LEFT JOIN fileresources_image as file on s.previewfileresource = file.uuid WHERE s.uuid = :uuid";
        SubtopicImpl result = (SubtopicImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(SubtopicImpl.class, (String)"s"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            SubtopicImpl subtopic = map.computeIfAbsent((UUID)rowView.getColumn("s_uuid", UUID.class), fn -> (SubtopicImpl)rowView.getRow(SubtopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                subtopic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                subtopic.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        if (result != null) {
            result.setChildren(this.getChildren((Subtopic)result));
        }
        return result;
    }

    @Override
    public Subtopic findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String query = "SELECT s.uuid s_uuid, s.label s_label, s.description s_description, s.identifiable_type s_type, s.created s_created, s.last_modified s_lastModified, s.preview_hints s_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM subtopics as s LEFT JOIN identifiers as id on s.uuid = id.identifiable LEFT JOIN fileresources_image as file on s.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        String identifierId = identifier.getId();
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(SubtopicImpl.class, (String)"s"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            SubtopicImpl subtopic = map.computeIfAbsent((UUID)rowView.getColumn("s_uuid", UUID.class), fn -> (SubtopicImpl)rowView.getRow(SubtopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                subtopic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                subtopic.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        Subtopic subtopic = result.orElse(null);
        if (subtopic != null) {
            subtopic.setChildren(this.getChildren(subtopic));
        }
        return subtopic;
    }

    public List<Subtopic> getChildren(UUID uuid) {
        String query = "SELECT s.uuid s_uuid, s.label s_label, s.description s_description, s.identifiable_type s_type, s.created s_created, s.last_modified s_lastModified, s.preview_hints s_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM subtopics as s INNER JOIN subtopic_subtopics ss ON s.uuid = ss.child_subtopic_uuid LEFT JOIN fileresources_image as file on s.previewfileresource = file.uuid WHERE ss.parent_subtopic_uuid = :uuid ORDER BY ss.sortIndex ASC";
        ArrayList<Subtopic> result = new ArrayList<Subtopic>((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(SubtopicImpl.class, (String)"s"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            SubtopicImpl subtopic = map.computeIfAbsent((UUID)rowView.getColumn("s_uuid", UUID.class), fn -> (SubtopicImpl)rowView.getRow(SubtopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                subtopic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        return result;
    }

    public PageResponse<Subtopic> getChildren(UUID uuid, PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(BASE_CHILDREN_QUERY);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query.toString()).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(SubtopicImpl.class, (String)"s"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            SubtopicImpl subtopic = map.computeIfAbsent((UUID)rowView.getColumn("s_uuid", UUID.class), fn -> (SubtopicImpl)rowView.getRow(SubtopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                subtopic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        String sql = "SELECT count(*) FROM subtopics as s INNER JOIN subtopic_subtopics ss ON s.uuid = ss.child_subtopic_uuid WHERE ss.parent_subtopic_uuid = :uuid";
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sql).bind("uuid", (Object)uuid)).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public List<Entity> getEntities(Subtopic subtopic) {
        return this.getEntities(subtopic.getUuid());
    }

    public List<Entity> getEntities(UUID subtopicUuid) {
        String query = "SELECT e.uuid e_uuid, e.refid e_refId, e.label e_label, e.description e_description, e.identifiable_type e_type, e.entity_type e_entityType, e.created e_created, e.last_modified e_lastModified, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM entities as e INNER JOIN subtopic_entities se ON e.uuid = se.entity_uuid LEFT JOIN fileresources_image as file on e.previewfileresource = file.uuid LEFT JOIN identifiers as id on e.uuid = id.identifiable WHERE se.subtopic_uuid = :uuid ORDER BY se.sortIndex ASC";
        List<Entity> result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)subtopicUuid)).registerRowMapper(BeanMapper.factory(EntityImpl.class, (String)"e"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            EntityImpl entity = map.computeIfAbsent((UUID)rowView.getColumn("e_uuid", UUID.class), fn -> (EntityImpl)rowView.getRow(EntityImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                entity.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                entity.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().map(e -> e).collect(Collectors.toList());
        return result;
    }

    public List<FileResource> getFileResources(UUID subtopicUuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_type, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimeType, pf.uuid pf_uuid, pf.filename pf_filename, pf.mimetype pf_mimeType, pf.size_in_bytes pf_sizeInBytes, pf.uri pf_uri, pf.http_base_url pf_httpBaseUrl FROM fileresources as f INNER JOIN subtopic_fileresources sf ON f.uuid = sf.fileresource_uuid LEFT JOIN fileresources_image as pf on f.previewfileresource = pf.uuid WHERE sf.subtopic_uuid = :uuid ORDER BY sf.sortIndex ASC";
        List<FileResource> result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)subtopicUuid)).registerRowMapper(BeanMapper.factory(FileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            FileResourceImpl fileResource = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), fn -> (FileResourceImpl)rowView.getRow(FileResourceImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                fileResource.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        }))).values().stream().map(FileResource.class::cast).collect(Collectors.toList());
        return result;
    }

    public Subtopic getParent(UUID uuid) {
        String query = "SELECT s.uuid s_uuid, s.label s_label, s.description s_description, s.identifiable_type s_type, s.created s_created, s.last_modified s_lastModified, s.preview_hints s_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM subtopics as s LEFT JOIN fileresources_image as file on s.previewfileresource = file.uuid INNER JOIN subtopic_subtopics ss ON s.uuid = ss.parent_subtopic_uuid WHERE ss.child_subtopic_uuid = :uuid";
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(SubtopicImpl.class, (String)"s"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            SubtopicImpl parentSubtopic = map.computeIfAbsent((UUID)rowView.getColumn("s_uuid", UUID.class), fn -> (SubtopicImpl)rowView.getRow(SubtopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                parentSubtopic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        }))).values().stream().findFirst();
        return result.orElse(null);
    }

    @Override
    public Subtopic save(Subtopic subtopic) {
        subtopic.setUuid(UUID.randomUUID());
        subtopic.setCreated(LocalDateTime.now());
        subtopic.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = subtopic.getPreviewImage() == null ? null : subtopic.getPreviewImage().getUuid();
        String query = "INSERT INTO subtopics(uuid, label, description, previewfileresource, preview_hints, identifiable_type, created, last_modified) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :created, :lastModified)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)subtopic)).execute());
        Set identifiers = subtopic.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)subtopic);
        Subtopic result = this.findOne(subtopic.getUuid());
        return result;
    }

    public List<Entity> saveEntities(UUID subtopicUuid, List<Entity> entities) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM subtopic_entities WHERE subtopic_uuid = :uuid").bind("uuid", (Object)subtopicUuid)).execute());
        if (entities != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO subtopic_entities(subtopic_uuid, entity_uuid, sortIndex) VALUES(:uuid, :entityUuid, :sortIndex)");
                for (Entity entity : entities) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)subtopicUuid)).bind("entityUuid", (Object)entity.getUuid())).bind("sortIndex", this.getIndex(entities, (Identifiable)entity))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getEntities(subtopicUuid);
    }

    public List<Subtopic> getSubtopicsOfEntity(UUID entityUuid) {
        String query = "SELECT s.uuid s_uuid, s.label s_label, s.description s_description, s.identifiable_type s_type, s.created s_created, s.last_modified s_lastModified, s.preview_hints s_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM subtopics as s LEFT JOIN fileresources_image as file on s.previewfileresource = file.uuid INNER JOIN subtopic_entities se ON s.uuid = se.subtopic_uuid WHERE se.entity_uuid = :uuid";
        List<Subtopic> result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)entityUuid)).registerRowMapper(BeanMapper.factory(SubtopicImpl.class, (String)"s"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            SubtopicImpl parentSubtopic = map.computeIfAbsent((UUID)rowView.getColumn("s_uuid", UUID.class), fn -> (SubtopicImpl)rowView.getRow(SubtopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                parentSubtopic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        }))).values().stream().map(Subtopic.class::cast).collect(Collectors.toList());
        return result;
    }

    public List<Subtopic> getSubtopicsOfFileResource(UUID fileResourceUuid) {
        String query = "SELECT s.uuid s_uuid, s.label s_label, s.description s_description, s.identifiable_type s_type, s.created s_created, s.last_modified s_lastModified, s.preview_hints s_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM subtopics as s LEFT JOIN fileresources_image as file on s.previewfileresource = file.uuid INNER JOIN subtopic_fileresources sf ON s.uuid = sf.subtopic_uuid WHERE sf.fileresource_uuid = :uuid";
        List<Subtopic> result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)fileResourceUuid)).registerRowMapper(BeanMapper.factory(SubtopicImpl.class, (String)"s"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            SubtopicImpl parentSubtopic = map.computeIfAbsent((UUID)rowView.getColumn("s_uuid", UUID.class), fn -> (SubtopicImpl)rowView.getRow(SubtopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                parentSubtopic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        }))).values().stream().map(Subtopic.class::cast).collect(Collectors.toList());
        return result;
    }

    public List<FileResource> saveFileResources(UUID subtopicUuid, List<FileResource> fileResources) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM subtopic_fileresources WHERE subtopic_uuid = :uuid").bind("uuid", (Object)subtopicUuid)).execute());
        if (fileResources != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO subtopic_fileresources(subtopic_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
                for (FileResource fileResource : fileResources) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)subtopicUuid)).bind("fileResourceUuid", (Object)fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getFileResources(subtopicUuid);
    }

    public Subtopic saveWithParentSubtopic(Subtopic subtopic, UUID parentSubtopicUuid) {
        UUID childSubtopicUuid = subtopic.getUuid() == null ? this.save(subtopic).getUuid() : subtopic.getUuid();
        Integer sortindex = this.selectNextSortIndexForParentChildren(this.dbi, "subtopic_subtopics", "parent_subtopic_uuid", parentSubtopicUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO subtopic_subtopics(parent_subtopic_uuid, child_subtopic_uuid, sortindex) VALUES (:parent_subtopic_uuid, :child_subtopic_uuid, :sortindex)").bind("parent_subtopic_uuid", (Object)parentSubtopicUuid)).bind("child_subtopic_uuid", (Object)childSubtopicUuid)).bind("sortindex", sortindex)).execute());
        return this.findOne(childSubtopicUuid);
    }

    public Integer deleteFromParentSubtopic(UUID subtopicUuid, UUID parentSubtopicUuid) {
        Integer count = (Integer)this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM subtopic_subtopics WHERE parent_subtopic_uuid=:parent_subtopic_uuid AND child_subtopic_uuid=:child_subtopic_uuid").bind("parent_subtopic_uuid", (Object)parentSubtopicUuid)).bind("child_subtopic_uuid", (Object)subtopicUuid)).execute());
        return count;
    }

    public Subtopic saveWithParentTopic(Subtopic subtopic, UUID parentTopicUuid) {
        UUID childSubtopicUuid = subtopic.getUuid() == null ? this.save(subtopic).getUuid() : subtopic.getUuid();
        Integer sortindex = this.selectNextSortIndexForParentChildren(this.dbi, "topic_subtopics", "topic_uuid", parentTopicUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO topic_subtopics(topic_uuid, subtopic_uuid, sortindex) VALUES (:parent_topic_uuid, :child_subtopic_uuid, :sortindex)").bind("parent_topic_uuid", (Object)parentTopicUuid)).bind("child_subtopic_uuid", (Object)childSubtopicUuid)).bind("sortindex", sortindex)).execute());
        return this.findOne(childSubtopicUuid);
    }

    public Integer deleteFromParentTopic(UUID subtopicUuid, UUID topicUuid) {
        Integer count = (Integer)this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM topic_subtopics WHERE topic_uuid=:topic_uuid AND subtopic_uuid=:subtopic_uuid").bind("topic_uuid", (Object)topicUuid)).bind("subtopic_uuid", (Object)subtopicUuid)).execute());
        return count;
    }

    @Override
    public Subtopic update(Subtopic subtopic) {
        subtopic.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = subtopic.getPreviewImage() == null ? null : subtopic.getPreviewImage().getUuid();
        String query = "UPDATE subtopics SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)subtopic)).execute());
        this.deleteIdentifiers((Identifiable)subtopic);
        Set identifiers = subtopic.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)subtopic);
        Subtopic result = this.findOne(subtopic.getUuid());
        return result;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "s.created";
            }
            case "lastModified": {
                return "s.last_modified";
            }
        }
        return null;
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(BREADCRUMB_QUERY).bind("uuid", (Object)nodeUuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(BREADCRUMB_WITHOUT_PARENT_QUERY).bind("uuid", (Object)nodeUuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).list());
        }
        List nodes = result.stream().map(s -> s).collect(Collectors.toList());
        return new BreadcrumbNavigationImpl(nodes);
    }

    public Topic getTopic(UUID rootSubtopicUuid) {
        String query = "SELECT uuid, refid, label FROM topics INNER JOIN topic_subtopics ts ON uuid = ts.topic_uuid WHERE ts.subtopic_uuid = :uuid";
        TopicImpl result = (TopicImpl)this.dbi.withHandle(h -> (TopicImpl)((Query)h.createQuery(query).bind("uuid", (Object)rootSubtopicUuid)).mapToBean(TopicImpl.class).one());
        return result;
    }
}

