/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.agent.PersonRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.agent.Agent;
import de.digitalcollections.model.api.identifiable.entity.agent.Person;
import de.digitalcollections.model.api.identifiable.entity.work.Work;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.entity.DigitalObjectImpl;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import de.digitalcollections.model.impl.identifiable.entity.agent.PersonImpl;
import de.digitalcollections.model.impl.identifiable.entity.work.WorkImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PersonRepositoryImpl
extends IdentifiableRepositoryImpl<Person>
implements PersonRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonRepositoryImpl.class);

    @Autowired
    public PersonRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM persons";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<Person> find(PageRequest pageRequest) {
        String language = "de";
        StringBuilder query = new StringBuilder("SELECT p.uuid p_uuid, p.label p_label, p.description p_description, p.refid p_refId, p.dateOfBirth p_dateOfBirth, p.timevalueofbirth p_timevalueofbirth, p.dateOfDeath p_dateOfDeath, p.timevalueofdeath p_timevalueofdeath, p.gender p_gender, file.uri f_uri, file.filename f_filename FROM persons as p LEFT JOIN fileresources_image as file on p.previewfileresource = file.uuid ORDER BY p.label ->> :language");
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query.toString()).bind("language", language)).registerRowMapper(BeanMapper.factory(PersonImpl.class, (String)"p"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            Person person = map.computeIfAbsent((UUID)rowView.getColumn("p_uuid", UUID.class), uuid -> (Person)rowView.getRow(PersonImpl.class));
            if (rowView.getColumn("f_uri", String.class) != null) {
                person.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        String countQuery = "SELECT count(DISTINCT persons.uuid) FROM persons WHERE label ->> :language IS NOT null";
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(countQuery).bind("language", language)).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public PageResponse<Person> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) {
        StringBuilder query = new StringBuilder("SELECT p.uuid p_uuid, p.label p_label, p.description p_description, p.refid p_refId, p.dateOfBirth p_dateOfBirth, p.timevalueofbirth p_timevalueofbirth, p.dateOfDeath p_dateOfDeath, p.timevalueofdeath p_timevalueofdeath, p.gender p_gender, file.uri f_uri, file.filename f_filename FROM persons as p LEFT JOIN fileresources_image as file on p.previewfileresource = file.uuid WHERE p.label ->> :language IS NOT null AND p.label ->> :language ILIKE :initial || '%' ORDER BY p.label ->> :language");
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query.toString()).bind("language", language)).bind("initial", initial)).registerRowMapper(BeanMapper.factory(PersonImpl.class, (String)"p"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            Person person = map.computeIfAbsent((UUID)rowView.getColumn("p_uuid", UUID.class), uuid -> (Person)rowView.getRow(PersonImpl.class));
            if (rowView.getColumn("f_uri", String.class) != null) {
                person.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        String countQuery = "SELECT count(DISTINCT persons.uuid) FROM persons WHERE label ->> :language IS NOT null AND label ->> :language ILIKE :initial || '%'";
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)((Query)h.createQuery(countQuery).bind("language", language)).bind("initial", initial)).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Person findOne(UUID uuid) {
        String query = "SELECT p.uuid p_uuid, p.label p_label, p.description p_description, p.refid p_refId, p.identifiable_type p_type, p.entity_type p_entityType, p.created p_created, p.last_modified p_last_modified, p.dateOfBirth p_dateOfBirth, p.timevalueofbirth p_timevalueofbirth, p.dateOfDeath p_dateOfDeath, p.timevalueofdeath p_timevalueofdeath, p.gender p_gender, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uri f_uri, file.filename f_filename FROM persons as p LEFT JOIN identifiers as id on p.uuid = id.identifiable LEFT JOIN fileresources_image as file on p.previewfileresource = file.uuid WHERE p.uuid = :uuid";
        Optional resultOpt = (Optional)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(PersonImpl.class, (String)"p"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            Person person = map.computeIfAbsent((UUID)rowView.getColumn("p_uuid", UUID.class), id -> (Person)rowView.getRow(PersonImpl.class));
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                person.addIdentifier((Identifier)identifier);
            }
            if (rowView.getColumn("f_uri", String.class) != null) {
                person.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values().stream().findFirst());
        if (!resultOpt.isPresent()) {
            return null;
        }
        return (Person)resultOpt.get();
    }

    @Override
    public Person findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String query = "SELECT p.uuid p_uuid, p.label p_label, p.description p_description, p.refid p_refId, p.identifiable_type p_type, p.entity_type p_entityType, p.created p_created, p.last_modified p_last_modified, p.dateOfBirth p_dateOfBirth, p.timevalueofbirth p_timevalueofbirth, p.dateOfDeath p_dateOfDeath, p.timevalueofdeath p_timevalueofdeath, p.gender p_gender, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uri f_uri, file.filename f_filename FROM persons as p LEFT JOIN identifiers as id on p.uuid = id.identifiable LEFT JOIN fileresources_image as file on p.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        String identifierId = identifier.getId();
        Optional resultOpt = (Optional)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(PersonImpl.class, (String)"p"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            Person person = map.computeIfAbsent((UUID)rowView.getColumn("p_uuid", UUID.class), id -> (Person)rowView.getRow(PersonImpl.class));
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                person.addIdentifier((Identifier)rowView.getRow(IdentifierImpl.class));
            }
            if (rowView.getColumn("f_uri", String.class) != null) {
                person.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values().stream().findFirst());
        if (!resultOpt.isPresent()) {
            return null;
        }
        return (Person)resultOpt.get();
    }

    @Override
    public Person findOneByIdentifier(String namespace, String id) {
        return this.findOne((Identifier)new IdentifierImpl(null, namespace, id));
    }

    @Override
    public Person save(Person person) {
        if (person.getUuid() == null) {
            person.setUuid(UUID.randomUUID());
        }
        person.setCreated(LocalDateTime.now());
        person.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = person.getPreviewImage() == null ? null : person.getPreviewImage().getUuid();
        String query = "INSERT INTO persons(uuid, previewFileResource, label, description, identifiable_type, entity_type, created, last_modified, dateOfBirth, timeValueOfBirth, dateOfDeath, timeValueOfDeath, gender) VALUES (:uuid, :previewFileResource, :label::JSONB, :description::JSONB, :type, :entityType, :created, :lastModified, :dateOfBirth, :timeValueOfBirth::JSONB, :dateOfDeath, :timeValueOfDeath::JSONB, :gender)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)person)).execute());
        Set identifiers = person.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)person);
        Person result = this.findOne(person.getUuid());
        return result;
    }

    @Override
    public Person update(Person person) {
        person.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = person.getPreviewImage() == null ? null : person.getPreviewImage().getUuid();
        String query = "UPDATE persons SET previewFileResource=:previewFileResource, label=:label::JSONB, description=:description::JSONB, last_modified=:lastModified, dateOfBirth=:dateOfBirth, timeValueOfBirth=:timeValueOfBirth::JSONB, dateOfDeath=:dateOfDeath, timeValueOfDeath=:timeValueOfDeath::JSONB, gender=:gender WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)person)).execute());
        Set identifiers = person.getIdentifiers();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM identifiers WHERE identifiable = :uuid").bind("uuid", (Object)person.getUuid())).execute());
        this.saveIdentifiers(identifiers, (Identifiable)person);
        Person result = this.findOne(person.getUuid());
        return result;
    }

    public Set<Work> getWorks(UUID uuidPerson) {
        String query = "SELECT w.uuid w_uuid, w.label w_label, w.refid w_refId, w.created w_created, w.last_modified w_lastModified, w.date_published w_datePublished, w.timevalue_published w_timeValuePublished, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimetype, file.size_in_bytes pf_size_in_bytes, file.uri pf_uri, e.uuid e_uuid, e.label e_label, e.refid e_refId FROM works as w LEFT JOIN identifiers as id on w.uuid = id.identifiable LEFT JOIN work_creators as wc on w.uuid = wc.work_uuid LEFT JOIN entities as e on e.uuid = wc.agent_uuid LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid WHERE wc.agent_uuid = :uuid ORDER BY wc.sortIndex ASC";
        Set result = (Set)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuidPerson)).registerRowMapper(BeanMapper.factory(WorkImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).registerRowMapper(BeanMapper.factory(EntityImpl.class, (String)"e"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            Work work = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (Work)rowView.getRow(WorkImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                work.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                work.addIdentifier((Identifier)dbIdentifier);
            }
            if (rowView.getColumn("e_uuid", UUID.class) != null) {
                EntityImpl agent = (EntityImpl)rowView.getRow(EntityImpl.class);
                UUID agentUuid = agent.getUuid();
                List creators = work.getCreators();
                boolean contained = false;
                for (Agent creator : creators) {
                    if (!agentUuid.equals(creator.getUuid())) continue;
                    contained = true;
                }
                if (!contained) {
                    PersonImpl person = new PersonImpl();
                    person.setLabel(agent.getLabel());
                    person.setRefId(agent.getRefId());
                    person.setUuid(agent.getUuid());
                    work.getCreators().add(person);
                }
            }
            return map;
        })).values().stream().collect(Collectors.toSet()));
        return result;
    }

    public Set<DigitalObject> getDigitalObjects(UUID uuidPerson) {
        String query = "SELECT d.uuid d_uuid, d.label d_label, d.refid d_refId, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimetype, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.http_base_url pf_httpBaseUrl FROM digitalobjects as d LEFT JOIN item_digitalobjects as itdi on d.uuid = itdi.digitalobject_uuid LEFT JOIN item_works as itwo on itdi.item_uuid = itwo.item_uuid LEFT JOIN work_creators as wocr on itwo.work_uuid = wocr.work_uuid LEFT JOIN fileresources_image as file on d.previewfileresource = file.uuid WHERE wocr.agent_uuid = :uuid";
        Set result = (Set)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuidPerson)).registerRowMapper(BeanMapper.factory(DigitalObjectImpl.class, (String)"d"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            DigitalObject digitalObject = map.computeIfAbsent((UUID)rowView.getColumn("d_uuid", UUID.class), fn -> (DigitalObject)rowView.getRow(DigitalObjectImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                digitalObject.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values().stream().collect(Collectors.toSet()));
        return result;
    }
}

