/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.VersionRepository;
import de.digitalcollections.model.api.identifiable.Version;
import de.digitalcollections.model.impl.identifiable.VersionImpl;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class VersionRepositoryImpl
implements VersionRepository {
    private Jdbi dbi;

    @Autowired
    public VersionRepositoryImpl(Jdbi dbi) {
        this.dbi = dbi;
    }

    public Version findOne(UUID uuid) {
        Version version = (Version)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT * FROM versions WHERE uuid = :uuid").bind("uuid", (Object)uuid)).mapToBean(VersionImpl.class).findOne().orElse(null));
        return version;
    }

    public Version findOneByInstanceversionKey(String instVersionKey) {
        Optional version = (Optional)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT * FROM versions WHERE instance_version_key = :instance_version_key").bind("instance_version_key", instVersionKey)).mapToBean(VersionImpl.class).findFirst());
        if (version.isPresent()) {
            return (Version)version.get();
        }
        return null;
    }

    public Version save(Version version) {
        version.setUuid(UUID.randomUUID());
        version.setCreated(new Date());
        VersionImpl result = (VersionImpl)this.dbi.withHandle(h -> ((Query)h.createQuery("INSERT INTO versions(uuid, version_value, type_key, instance_key, instance_version_key, description, created, status) VALUES (:uuid, :versionValue, :typeKey, :instanceKey, :instanceVersionKey, :description, :created, :status) RETURNING *").bindBean((Object)version)).mapToBean(VersionImpl.class).findOne().orElse(null));
        return result;
    }

    public Version update(Version version) {
        Version result = (Version)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE versions SET status=:status WHERE uuid=:uuid RETURNING *").bindBean((Object)version)).mapToBean(VersionImpl.class).findOne().orElse(null));
        return result;
    }
}

