/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.work;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.identifiable.entity.manifestation.Manifestation;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface ItemRepository
extends EntityRepository<Item> {
    default public PageResponse<Item> findItemsByManifestation(Manifestation manifestation, PageRequest pageRequest) throws RepositoryException {
        if (manifestation == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findItemsByManifestation(manifestation.getUuid(), pageRequest);
    }

    public PageResponse<Item> findItemsByManifestation(UUID var1, PageRequest var2) throws RepositoryException;

    default public List<Locale> getLanguagesOfDigitalObjects(Item item) throws RepositoryException {
        if (item == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getLanguagesOfDigitalObjects(item.getUuid());
    }

    public List<Locale> getLanguagesOfDigitalObjects(UUID var1);

    default public List<Locale> getLanguagesOfItemsForManifestation(Manifestation manifestation) throws RepositoryException {
        if (manifestation == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getLanguagesOfItemsForManifestation(manifestation.getUuid());
    }

    public List<Locale> getLanguagesOfItemsForManifestation(UUID var1);
}

