/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.agent;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.entity.work.Work;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.Set;
import java.util.UUID;

public interface AgentRepository<A extends Agent>
extends EntityRepository<A> {
    default public PageResponse<DigitalObject> findDigitalObjects(A agent, PageRequest pageRequest) throws RepositoryException {
        if (agent == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findDigitalObjects(agent.getUuid(), pageRequest);
    }

    public PageResponse<DigitalObject> findDigitalObjects(UUID var1, PageRequest var2) throws RepositoryException;

    default public PageResponse<Work> findWorks(A agent, PageRequest pageRequest) throws RepositoryException {
        if (agent == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findWorks(agent.getUuid(), pageRequest);
    }

    public PageResponse<Work> findWorks(UUID var1, PageRequest var2) throws RepositoryException;

    default public Set<DigitalObject> getDigitalObjects(A agent) throws RepositoryException {
        if (agent == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getDigitalObjects(agent.getUuid());
    }

    public Set<DigitalObject> getDigitalObjects(UUID var1) throws RepositoryException;

    default public Set<Work> getWorks(A agent) throws RepositoryException {
        if (agent == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getWorks(agent.getUuid());
    }

    public Set<Work> getWorks(UUID var1) throws RepositoryException;
}

