/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface DigitalObjectRepository
extends EntityRepository<DigitalObject> {
    default public void deleteFileResources(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("delete failed: given object must not be null");
        }
        this.deleteFileResources(digitalObject.getUuid());
    }

    public void deleteFileResources(UUID var1) throws RepositoryException;

    default public PageResponse<Collection> findCollections(DigitalObject digitalObject, PageRequest pageRequest) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findCollections(digitalObject.getUuid(), pageRequest);
    }

    public PageResponse<Collection> findCollections(UUID var1, PageRequest var2) throws RepositoryException;

    default public PageResponse<FileResource> findFileResources(DigitalObject digitalObject, PageRequest pageRequest) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findFileResources(digitalObject.getUuid(), pageRequest);
    }

    public PageResponse<FileResource> findFileResources(UUID var1, PageRequest var2) throws RepositoryException;

    default public PageResponse<ImageFileResource> findImageFileResources(DigitalObject digitalObject, PageRequest pageRequest) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findImageFileResources(digitalObject.getUuid(), pageRequest);
    }

    public PageResponse<ImageFileResource> findImageFileResources(UUID var1, PageRequest var2) throws RepositoryException;

    default public PageResponse<Project> findProjects(DigitalObject digitalObject, PageRequest pageRequest) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findProjects(digitalObject.getUuid(), pageRequest);
    }

    public PageResponse<Project> findProjects(UUID var1, PageRequest var2) throws RepositoryException;

    default public PageResponse<DigitalObject> findDigitalObjectsByItem(Item item, PageRequest pageRequest) throws RepositoryException {
        if (item == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findDigitalObjectsByItem(item.getUuid(), pageRequest);
    }

    public PageResponse<DigitalObject> findDigitalObjectsByItem(UUID var1, PageRequest var2) throws RepositoryException;

    default public List<FileResource> getFileResources(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getFileResources(digitalObject.getUuid());
    }

    public List<FileResource> getFileResources(UUID var1) throws RepositoryException;

    default public List<ImageFileResource> getIiifImageFileResources(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getIiifImageFileResources(digitalObject.getUuid());
    }

    public List<ImageFileResource> getIiifImageFileResources(UUID var1) throws RepositoryException;

    default public List<ImageFileResource> getImageFileResources(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getImageFileResources(digitalObject.getUuid());
    }

    public List<ImageFileResource> getImageFileResources(UUID var1) throws RepositoryException;

    default public List<Locale> getLanguagesOfCollections(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getLanguagesOfCollections(digitalObject.getUuid());
    }

    public List<Locale> getLanguagesOfCollections(UUID var1) throws RepositoryException;

    default public List<Locale> getLanguagesOfContainedDigitalObjects(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getLanguagesOfContainedDigitalObjects(digitalObject.getUuid());
    }

    public List<Locale> getLanguagesOfContainedDigitalObjects(UUID var1) throws RepositoryException;

    default public List<Locale> getLanguagesOfProjects(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getLanguagesOfProjects(digitalObject.getUuid());
    }

    public List<Locale> getLanguagesOfProjects(UUID var1) throws RepositoryException;

    default public List<FileResource> setFileResources(DigitalObject digitalObject, List<FileResource> fileResources) throws RepositoryException {
        if (digitalObject == null || fileResources == null) {
            throw new IllegalArgumentException("set failed: given objects must not be null");
        }
        return this.setFileResources(digitalObject.getUuid(), fileResources);
    }

    public List<FileResource> setFileResources(UUID var1, List<FileResource> var2) throws RepositoryException;
}

