/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;

public interface NodeRepository<N extends Identifiable>
extends IdentifiableRepository<N> {
    default public boolean addChild(N parent, N child) throws RepositoryException {
        if (parent == null || child == null) {
            throw new IllegalArgumentException("parent and child must not be null");
        }
        return this.addChild(parent.getUuid(), child.getUuid());
    }

    default public boolean addChild(UUID parentUuid, UUID childUuid) throws RepositoryException {
        if (parentUuid == null || childUuid == null) {
            throw new IllegalArgumentException("parent and child uuids must not be null");
        }
        return this.addChildren(parentUuid, Arrays.asList(childUuid));
    }

    default public boolean addChildren(N parent, List<N> children) throws RepositoryException {
        if (parent == null || children == null) {
            throw new IllegalArgumentException("parent and children must not be null");
        }
        List<UUID> childrenUuids = children.stream().filter(c -> c.getUuid() != null).map(c -> c.getUuid()).collect(Collectors.toList());
        return this.addChildren(parent.getUuid(), childrenUuids);
    }

    public boolean addChildren(UUID var1, List<UUID> var2) throws RepositoryException;

    default public PageResponse<N> findChildren(N parent, PageRequest pageRequest) throws RepositoryException {
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        return this.findChildren(parent.getUuid(), pageRequest);
    }

    public PageResponse<N> findChildren(UUID var1, PageRequest var2) throws RepositoryException;

    public PageResponse<N> findRootNodes(PageRequest var1) throws RepositoryException;

    default public BreadcrumbNavigation getBreadcrumbNavigation(N node) throws RepositoryException {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        return this.getBreadcrumbNavigation(node.getUuid());
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID var1) throws RepositoryException;

    default public List<N> getChildren(N node) throws RepositoryException {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        return this.getChildren(node.getUuid());
    }

    public List<N> getChildren(UUID var1) throws RepositoryException;

    default public N getParent(N node) throws RepositoryException {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        return this.getParent(node.getUuid());
    }

    public N getParent(UUID var1) throws RepositoryException;

    default public List<N> getParents(N node) throws RepositoryException {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        return this.getParents(node.getUuid());
    }

    public List<N> getParents(UUID var1) throws RepositoryException;

    public List<Locale> getRootNodesLanguages() throws RepositoryException;

    default public boolean removeChild(N parent, N child) throws RepositoryException {
        if (parent == null || child == null) {
            throw new IllegalArgumentException("parent and child must not be null");
        }
        return this.removeChild(parent.getUuid(), child.getUuid());
    }

    public boolean removeChild(UUID var1, UUID var2) throws RepositoryException;

    default public N saveParentRelation(N child, N parent) throws RepositoryException {
        if (parent == null || child == null) {
            throw new IllegalArgumentException("Parent and child must not be null");
        }
        if (parent.getUuid() == null || child.getUuid() == null) {
            throw new IllegalArgumentException("Parent and Child must have been saved already");
        }
        return this.saveParentRelation(child.getUuid(), parent.getUuid());
    }

    public N saveParentRelation(UUID var1, UUID var2) throws RepositoryException;

    default public boolean updateChildrenOrder(N parent, List<N> children) throws RepositoryException {
        if (parent == null || children == null) {
            throw new IllegalArgumentException("parent and children must not be null");
        }
        List<UUID> childrenUuids = children.stream().filter(c -> c.getUuid() == null).map(c -> c.getUuid()).collect(Collectors.toList());
        return this.updateChildrenOrder(parent.getUuid(), childrenUuids);
    }

    public boolean updateChildrenOrder(UUID var1, List<UUID> var2) throws RepositoryException;
}

