/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.UniqueObjectRepository;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public interface IdentifierRepository
extends UniqueObjectRepository<Identifier> {
    default public int deleteByIdentifiable(Identifiable identifiable) throws RepositoryException {
        if (identifiable == null) {
            throw new IllegalArgumentException("delete failed: given object must not be null");
        }
        return this.deleteByIdentifiable(identifiable.getUuid());
    }

    public int deleteByIdentifiable(UUID var1) throws RepositoryException;

    default public List<Identifier> findByIdentifiable(Identifiable identifiable) throws RepositoryException {
        if (identifiable == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findByIdentifiable(identifiable.getUuid());
    }

    public List<Identifier> findByIdentifiable(UUID var1) throws RepositoryException;

    default public List<Identifier> getByIdentifiers(List<Identifier> identifiers) throws RepositoryException {
        if (identifiers == null) {
            throw new IllegalArgumentException("get failed: given objects must not be null");
        }
        return this.getByUuids(identifiers.stream().map(UniqueObject::getUuid).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    default public void save(Identifier uniqueObject) throws RepositoryException {
        throw new UnsupportedOperationException("saving without related Identifiable not supported - use saveForIdentifiable instead.");
    }

    public Set<Identifier> saveForIdentifiable(Identifiable var1, Set<Identifier> var2) throws RepositoryException;
}

