/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias;

import de.digitalcollections.cudami.server.backend.api.repository.UniqueObjectRepository;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;

public interface UrlAliasRepository
extends UniqueObjectRepository<UrlAlias> {
    public static String grabLanguage(Locale locale) {
        if (locale == null) {
            return "und";
        }
        return locale.toLanguageTag().split("-", 2)[0];
    }

    public static Locale grabLanguageLocale(Locale locale) {
        return Locale.forLanguageTag(UrlAliasRepository.grabLanguage(locale));
    }

    public static List<Locale> grabLocalesByScript(Collection<Locale> locales) {
        if (locales == null) {
            return Collections.emptyList();
        }
        List<String> scripts = List.of("", "Latn");
        return locales.stream().filter(l -> l != null && scripts.contains(l.getScript())).collect(Collectors.toList());
    }

    default public boolean deleteByIdentifiable(Identifiable identifiable, boolean force) throws RepositoryException {
        if (identifiable == null) {
            throw new IllegalArgumentException("delete failed: given object must not be null");
        }
        return this.deleteByIdentifiable(identifiable.getUuid(), force);
    }

    public boolean deleteByIdentifiable(UUID var1, boolean var2) throws RepositoryException;

    public LocalizedUrlAliases findAllPrimaryLinks(String var1) throws RepositoryException;

    public PageResponse<LocalizedUrlAliases> findLocalizedUrlAliases(PageRequest var1) throws RepositoryException;

    default public LocalizedUrlAliases findPrimaryLinksForWebsite(UUID websiteUuid, String slug) throws RepositoryException {
        return this.findPrimaryLinksForWebsite(websiteUuid, slug, true);
    }

    default public LocalizedUrlAliases findPrimaryLinksForWebsite(Website website, String slug) throws RepositoryException {
        if (website == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findPrimaryLinksForWebsite(website.getUuid(), slug, true);
    }

    public LocalizedUrlAliases findPrimaryLinksForWebsite(UUID var1, String var2, boolean var3) throws RepositoryException;

    default public LocalizedUrlAliases findPrimaryLinksForWebsite(Website website, String slug, boolean considerLanguage) throws RepositoryException {
        UUID websiteUuid = null;
        if (website != null) {
            websiteUuid = website.getUuid();
        }
        return this.findPrimaryLinksForWebsite(websiteUuid, slug, considerLanguage);
    }

    default public LocalizedUrlAliases getByIdentifiable(Identifiable identifiable) throws RepositoryException {
        if (identifiable == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getByIdentifiable(identifiable.getUuid());
    }

    public LocalizedUrlAliases getByIdentifiable(UUID var1) throws RepositoryException;

    public boolean hasUrlAlias(String var1, UUID var2, Locale var3) throws RepositoryException;

    default public boolean hasUrlAlias(String slug, Website website, Locale targetLanguage) throws RepositoryException {
        if (website == null) {
            return this.hasUrlAlias(slug, (UUID)null, targetLanguage);
        }
        return this.hasUrlAlias(slug, website.getUuid(), targetLanguage);
    }
}

