/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public interface DigitalObjectRenderingFileResourceRepository {
    public int countDigitalObjectsForResource(UUID var1) throws RepositoryException;

    default public int delete(FileResource fileResource) throws RepositoryException {
        return this.delete(Set.of(fileResource));
    }

    default public int delete(Set<FileResource> fileResources) throws RepositoryException {
        List<UUID> list = fileResources.stream().map(i -> i.getUuid()).collect(Collectors.toList());
        return this.delete(list);
    }

    public int delete(List<UUID> var1) throws RepositoryException;

    default public int delete(UUID uuid) throws RepositoryException {
        return this.delete(List.of(uuid));
    }

    default public PageResponse<FileResource> findRenderingFileResources(DigitalObject digitalObject, PageRequest pageRequest) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findRenderingFileResources(digitalObject.getUuid(), pageRequest);
    }

    public PageResponse<FileResource> findRenderingFileResources(UUID var1, PageRequest var2) throws RepositoryException;

    default public List<FileResource> getRenderingFileResources(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getRenderingFileResources(digitalObject.getUuid());
    }

    public List<FileResource> getRenderingFileResources(UUID var1) throws RepositoryException;

    default public int removeByDigitalObject(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("remove failed: given object must not be null");
        }
        return this.removeByDigitalObject(digitalObject.getUuid());
    }

    public int removeByDigitalObject(UUID var1) throws RepositoryException;

    default public List<FileResource> setRenderingFileResources(DigitalObject digitalObject, List<FileResource> renderingResources) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("set failed: given object must not be null");
        }
        if (renderingResources == null) {
            return null;
        }
        return this.setRenderingFileResources(digitalObject.getUuid(), renderingResources);
    }

    public List<FileResource> setRenderingFileResources(UUID var1, List<FileResource> var2) throws RepositoryException;
}

