/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.UUID;

public interface DigitalObjectLinkedDataFileResourceRepository {
    public int countDigitalObjectsForResource(UUID var1) throws RepositoryException;

    public int delete(List<UUID> var1) throws RepositoryException;

    default public int delete(UUID uuid) throws RepositoryException {
        return this.delete(List.of(uuid));
    }

    default public PageResponse<LinkedDataFileResource> findLinkedDataFileResources(DigitalObject digitalObject, PageRequest pageRequest) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findLinkedDataFileResources(digitalObject.getUuid(), pageRequest);
    }

    public PageResponse<LinkedDataFileResource> findLinkedDataFileResources(UUID var1, PageRequest var2) throws RepositoryException;

    default public List<LinkedDataFileResource> getLinkedDataFileResources(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getLinkedDataFileResources(digitalObject.getUuid());
    }

    public List<LinkedDataFileResource> getLinkedDataFileResources(UUID var1) throws RepositoryException;

    default public List<LinkedDataFileResource> setLinkedDataFileResources(DigitalObject digitalObject, List<LinkedDataFileResource> linkedDataFileResources) throws RepositoryException {
        if (digitalObject == null || linkedDataFileResources == null) {
            throw new IllegalArgumentException("set failed: given objects must not be null");
        }
        return this.setLinkedDataFileResources(digitalObject.getUuid(), linkedDataFileResources);
    }

    public List<LinkedDataFileResource> setLinkedDataFileResources(UUID var1, List<LinkedDataFileResource> var2) throws RepositoryException;
}

