/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.UniqueObjectRepository;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface IdentifiableRepository<I extends Identifiable>
extends UniqueObjectRepository<I> {
    default public void addRelatedEntity(I identifiable, Entity entity) throws RepositoryException {
        if (identifiable == null || entity == null) {
            throw new IllegalArgumentException("add failed: given objects must not be null");
        }
        this.addRelatedEntity(identifiable.getUuid(), entity.getUuid());
    }

    public void addRelatedEntity(UUID var1, UUID var2) throws RepositoryException;

    default public void addRelatedFileresource(I identifiable, FileResource fileResource) throws RepositoryException {
        if (identifiable == null || fileResource == null) {
            throw new IllegalArgumentException("add failed: given objects must not be null");
        }
        this.addRelatedFileresource(identifiable.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID var1, UUID var2) throws RepositoryException;

    public PageResponse<I> findByLanguageAndInitial(PageRequest var1, String var2, String var3) throws RepositoryException;

    default public PageResponse<Entity> findRelatedEntities(I identifiable, PageRequest pageRequest) throws RepositoryException {
        if (identifiable == null) {
            throw new IllegalArgumentException("find failed: given identifiable must not be null");
        }
        return this.findRelatedEntities(identifiable.getUuid(), pageRequest);
    }

    public PageResponse<Entity> findRelatedEntities(UUID var1, PageRequest var2) throws RepositoryException;

    default public PageResponse<FileResource> findRelatedFileResources(I identifiable, PageRequest pageRequest) throws RepositoryException {
        if (identifiable == null) {
            throw new IllegalArgumentException("find failed: given identifiable must not be null");
        }
        return this.findRelatedFileResources(identifiable.getUuid(), pageRequest);
    }

    public PageResponse<FileResource> findRelatedFileResources(UUID var1, PageRequest var2) throws RepositoryException;

    default public I getByIdentifiable(I identifiable) throws RepositoryException {
        if (identifiable == null) {
            throw new IllegalArgumentException("get failed: given identifiable must not be null");
        }
        return (I)((Identifiable)this.getByUuid(identifiable.getUuid()));
    }

    default public I getByIdentifier(Identifier identifier) throws RepositoryException {
        if (identifier == null) {
            throw new IllegalArgumentException("get failed: given identifier must not be null");
        }
        return this.getByIdentifier(identifier.getNamespace(), identifier.getId());
    }

    public I getByIdentifier(String var1, String var2) throws RepositoryException;

    public List<Locale> getLanguages() throws RepositoryException;

    default public List<Entity> setRelatedEntities(I identifiable, List<Entity> entities) throws RepositoryException {
        if (identifiable == null || entities == null) {
            throw new IllegalArgumentException("set failed: given objects must not be null");
        }
        return this.setRelatedEntities(identifiable.getUuid(), entities);
    }

    public List<Entity> setRelatedEntities(UUID var1, List<Entity> var2) throws RepositoryException;

    default public List<FileResource> setRelatedFileResources(I identifiable, List<FileResource> fileResources) throws RepositoryException {
        if (identifiable == null || fileResources == null) {
            throw new IllegalArgumentException("set failed: given objects must not be null");
        }
        return this.setRelatedFileResources(identifiable.getUuid(), fileResources);
    }

    public List<FileResource> setRelatedFileResources(UUID var1, List<FileResource> var2) throws RepositoryException;
}

