/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.web;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.UUID;

public interface WebpageRepository
extends NodeRepository<Webpage> {
    default public PageResponse<Webpage> findRootWebpagesForWebsite(Website website, PageRequest pageRequest) throws RepositoryException {
        if (website == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findRootWebpagesForWebsite(website.getUuid(), pageRequest);
    }

    public PageResponse<Webpage> findRootWebpagesForWebsite(UUID var1, PageRequest var2) throws RepositoryException;

    default public Website getWebsite(Webpage webpage) throws RepositoryException {
        if (webpage == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getWebsite(webpage.getUuid());
    }

    public Website getWebsite(UUID var1) throws RepositoryException;

    default public Webpage saveWithParentWebsite(Webpage webpage, Website website) throws RepositoryException {
        if (webpage == null || website == null) {
            throw new IllegalArgumentException("save failed: given objects must not be null");
        }
        return this.saveWithParentWebsite(webpage.getUuid(), website.getUuid());
    }

    public Webpage saveWithParentWebsite(UUID var1, UUID var2) throws RepositoryException;
}

