/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Topic;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface TopicRepository
extends NodeRepository<Topic>,
EntityRepository<Topic> {
    default public PageResponse<Entity> findEntities(Topic topic, PageRequest pageRequest) throws RepositoryException {
        if (topic == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findEntities(topic.getUuid(), pageRequest);
    }

    public PageResponse<Entity> findEntities(UUID var1, PageRequest var2) throws RepositoryException;

    default public PageResponse<FileResource> findFileResources(Topic topic, PageRequest pageRequest) throws RepositoryException {
        if (topic == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findFileResources(topic.getUuid(), pageRequest);
    }

    public PageResponse<FileResource> findFileResources(UUID var1, PageRequest var2) throws RepositoryException;

    default public PageResponse<Topic> findTopicsOfEntity(Entity entity, PageRequest pageRequest) throws RepositoryException {
        if (entity == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findTopicsOfEntity(entity.getUuid(), pageRequest);
    }

    public PageResponse<Topic> findTopicsOfEntity(UUID var1, PageRequest var2) throws RepositoryException;

    default public PageResponse<Topic> findTopicsOfFileResource(FileResource fileResource, PageRequest pageRequest) throws RepositoryException {
        if (fileResource == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findTopicsOfFileResource(fileResource.getUuid(), pageRequest);
    }

    public PageResponse<Topic> findTopicsOfFileResource(UUID var1, PageRequest var2) throws RepositoryException;

    default public List<FileResource> getFileResources(Topic topic) throws RepositoryException {
        if (topic == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getFileResources(topic.getUuid());
    }

    public List<FileResource> getFileResources(UUID var1) throws RepositoryException;

    default public List<Locale> getLanguagesOfEntities(Topic topic) throws RepositoryException {
        if (topic == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getLanguagesOfEntities(topic.getUuid());
    }

    public List<Locale> getLanguagesOfEntities(UUID var1) throws RepositoryException;

    default public List<Locale> getLanguagesOfFileResources(Topic topic) throws RepositoryException {
        if (topic == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getLanguagesOfFileResources(topic.getUuid());
    }

    public List<Locale> getLanguagesOfFileResources(UUID var1) throws RepositoryException;

    default public List<Topic> getTopicsOfEntity(Entity entity) throws RepositoryException {
        if (entity == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getTopicsOfEntity(entity.getUuid());
    }

    public List<Topic> getTopicsOfEntity(UUID var1) throws RepositoryException;

    default public List<Topic> getTopicsOfFileResource(FileResource fileResource) throws RepositoryException {
        if (fileResource == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getTopicsOfFileResource(fileResource.getUuid());
    }

    public List<Topic> getTopicsOfFileResource(UUID var1) throws RepositoryException;

    default public List<Entity> setEntities(Topic topic, List<Entity> entities) throws RepositoryException {
        if (topic == null) {
            throw new IllegalArgumentException("set failed: given object must not be null");
        }
        return this.setEntities(topic.getUuid(), entities);
    }

    public List<Entity> setEntities(UUID var1, List<Entity> var2) throws RepositoryException;

    default public List<FileResource> setFileResources(Topic topic, List<FileResource> fileResources) throws RepositoryException {
        if (topic == null) {
            throw new IllegalArgumentException("set failed: given object must not be null");
        }
        return this.setFileResources(topic.getUuid(), fileResources);
    }

    public List<FileResource> setFileResources(UUID var1, List<FileResource> var2) throws RepositoryException;
}

