/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public interface ProjectRepository
extends EntityRepository<Project> {
    default public boolean addDigitalObject(Project project, DigitalObject digitalObject) throws RepositoryException {
        if (project == null || digitalObject == null) {
            throw new IllegalArgumentException("add failed: given objects must not be null");
        }
        return this.addDigitalObjects(project.getUuid(), Arrays.asList(digitalObject));
    }

    default public boolean addDigitalObjects(Project project, List<DigitalObject> digitalObjects) throws RepositoryException {
        if (project == null || digitalObjects == null) {
            throw new IllegalArgumentException("add failed: given objects must not be null");
        }
        return this.addDigitalObjects(project.getUuid(), digitalObjects);
    }

    public boolean addDigitalObjects(UUID var1, List<DigitalObject> var2) throws RepositoryException;

    default public PageResponse<DigitalObject> findDigitalObjects(Project project, PageRequest pageRequest) throws RepositoryException {
        if (project == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findDigitalObjects(project.getUuid(), pageRequest);
    }

    public PageResponse<DigitalObject> findDigitalObjects(UUID var1, PageRequest var2) throws RepositoryException;

    default public boolean removeDigitalObject(Project project, DigitalObject digitalObject) throws RepositoryException {
        if (project == null || digitalObject == null) {
            throw new IllegalArgumentException("remove failed: given objects must not be null");
        }
        return this.removeDigitalObject(project.getUuid(), digitalObject.getUuid());
    }

    public boolean removeDigitalObject(UUID var1, UUID var2) throws RepositoryException;

    default public boolean removeDigitalObjectFromAllProjects(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("remove failed: given object must not be null");
        }
        return this.removeDigitalObjectFromAllProjects(digitalObject.getUuid());
    }

    public boolean removeDigitalObjectFromAllProjects(UUID var1) throws RepositoryException;

    default public boolean setDigitalObjects(Project project, List<DigitalObject> digitalObjects) throws RepositoryException {
        if (project == null || digitalObjects == null) {
            throw new IllegalArgumentException("set failed: given objects must not be null");
        }
        return this.setDigitalObjects(project.getUuid(), digitalObjects);
    }

    public boolean setDigitalObjects(UUID var1, List<DigitalObject> var2) throws RepositoryException;
}

