/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable;

import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import java.util.List;
import java.util.UUID;

public interface IdentifierRepository {
    public long count();

    default public void delete(UUID uuid) {
        this.delete(List.of(uuid));
    }

    public void delete(List<UUID> var1);

    default public void deleteByIdentifiable(Identifiable identifiable) {
        this.deleteByIdentifiable(identifiable.getUuid());
    }

    public void deleteByIdentifiable(UUID var1);

    public PageResponse<Identifier> find(PageRequest var1);

    public SearchPageResponse<Identifier> find(SearchPageRequest var1);

    default public List<Identifier> find(String searchTerm, int maxResults) {
        SearchPageRequest request = new SearchPageRequest(searchTerm, 0, maxResults, null);
        SearchPageResponse<Identifier> response = this.find(request);
        return response.getContent();
    }

    public List<Identifier> findByIdentifiable(UUID var1);

    public Identifier findOne(String var1, String var2);

    public Identifier save(Identifier var1);

    public Identifier update(Identifier var1);
}

