/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;

public interface NodeRepository<N extends Identifiable>
extends IdentifiableRepository<N> {
    default public boolean addChild(N parent, N child) {
        if (parent == null || child == null) {
            return false;
        }
        return this.addChild(parent.getUuid(), child.getUuid());
    }

    default public boolean addChild(UUID parentUuid, UUID childUuid) {
        if (parentUuid == null || childUuid == null) {
            return false;
        }
        return this.addChildren(parentUuid, Arrays.asList(childUuid));
    }

    default public boolean addChildren(N parent, List<N> children) {
        if (parent == null || children == null) {
            return false;
        }
        List<UUID> childrenUuids = children.stream().filter(c -> c.getUuid() == null).map(c -> c.getUuid()).collect(Collectors.toList());
        return this.addChildren(parent.getUuid(), childrenUuids);
    }

    public boolean addChildren(UUID var1, List<UUID> var2);

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID var1);

    default public List<N> getChildren(N node) {
        if (node == null) {
            return null;
        }
        return this.getChildren(node.getUuid());
    }

    public List<N> getChildren(UUID var1);

    public PageResponse<N> getChildren(UUID var1, PageRequest var2);

    public SearchPageResponse<N> findChildren(UUID var1, SearchPageRequest var2);

    public N getParent(UUID var1);

    public List<N> getParents(UUID var1);

    public PageResponse<N> getRootNodes(PageRequest var1);

    public SearchPageResponse<N> findRootNodes(SearchPageRequest var1);

    public List<Locale> getRootNodesLanguages();

    default public boolean removeChild(N parent, N child) {
        if (parent == null || child == null) {
            return false;
        }
        return this.removeChild(parent.getUuid(), child.getUuid());
    }

    public boolean removeChild(UUID var1, UUID var2);

    public N saveWithParent(UUID var1, UUID var2);

    public boolean updateChildrenOrder(UUID var1, List<N> var2);
}

