package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.relation;

import de.digitalcollections.model.api.identifiable.entity.relation.Predicate;
import java.util.List;

/** Repository for predicates handling */
public interface PredicateRepository {

  long count();

  void delete(String value);

  /**
   * Return all predicates
   *
   * @return List of all predicates
   */
  List<Predicate> findAll();

  /**
   * Returns a predicate, if available
   *
   * @param value unique value of predicate, e.g. "is_part_of"
   * @return Predicate or null
   */
  Predicate findOneByValue(String value);

  /**
   * Save a predicate. Since its field <code>value</code> is its primary key, there's no difference,
   * whether a predicate is created or updated.
   *
   * @param predicate the predicate to be saved
   * @return the saved predicate with update timestamps
   */
  Predicate save(Predicate predicate);
}
