/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.model.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.digitalcollections.model.MainSubType;
import de.digitalcollections.model.identifiable.entity.manifestation.ExpressionType;
import de.digitalcollections.model.text.TitleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TypeDeclarations {
    private List<String> manufacturingTypes;
    private List<String> mediaTypes;
    private List<String> relationPredicates;
    private List<String> subjectTypes;
    private List<ExpressionType> expressionTypes;
    private List<TitleType> titleTypes;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public TypeDeclarations(@JsonProperty(value="manufacturingTypes") List<String> manufacturingTypes, @JsonProperty(value="mediaTypes") List<String> mediaTypes, @JsonProperty(value="subjectTypes") List<String> subjectTypes, @JsonProperty(value="expressionTypes") List<ExpressionType> expressionTypes, @JsonProperty(value="titleTypes") List<TitleType> titleTypes) {
        this.manufacturingTypes = manufacturingTypes != null ? List.copyOf(manufacturingTypes) : Collections.emptyList();
        this.mediaTypes = mediaTypes != null ? List.copyOf(mediaTypes) : Collections.emptyList();
        this.subjectTypes = subjectTypes != null ? List.copyOf(subjectTypes) : Collections.emptyList();
        this.expressionTypes = expressionTypes != null ? List.copyOf(expressionTypes) : Collections.emptyList();
        this.titleTypes = titleTypes != null ? List.copyOf(titleTypes) : Collections.emptyList();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="filled at runtime")
    public List<String> getRelationPredicates() {
        return this.relationPredicates;
    }

    public List<String> getManufacturingTypes() {
        return List.copyOf(this.manufacturingTypes);
    }

    public List<String> getMediaTypes() {
        return List.copyOf(this.mediaTypes);
    }

    public List<String> getSubjectTypes() {
        return List.copyOf(this.subjectTypes);
    }

    public List<ExpressionType> getExpressionTypes() {
        return List.copyOf(this.expressionTypes);
    }

    public List<TitleType> getTitleTypes() {
        return List.copyOf(this.titleTypes);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="filled at runtime")
    public void setRelationPredicates(List<String> relationPredicates) {
        this.relationPredicates = relationPredicates;
    }

    private <T extends MainSubType> List<T> searchMainSubType(List<T> types, T pattern) {
        Optional<MainSubType> result = types.stream().filter(mst -> mst.equals((Object)pattern)).findFirst();
        if (result.isPresent()) {
            return List.of(result.get());
        }
        return types.stream().filter(mst -> mst.getMainType().equals(pattern.getMainType()) || mst.getSubType().equals(pattern.getSubType())).collect(Collectors.toList());
    }

    public List<ExpressionType> findExpressionTypes(String mainType, String subType) {
        if (mainType == null && subType == null) {
            return Collections.emptyList();
        }
        ExpressionType pattern = new ExpressionType(mainType, subType);
        return this.searchMainSubType(this.expressionTypes, pattern);
    }

    public List<TitleType> findTitleTypes(String mainType, String subType) {
        if (mainType == null && subType == null) {
            return Collections.emptyList();
        }
        TitleType pattern = new TitleType(mainType, subType);
        return this.searchMainSubType(this.titleTypes, pattern);
    }
}

