/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.model.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.digitalcollections.cudami.model.config.TypeDeclarations;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.springframework.util.StringUtils;

public class CudamiConfig {
    private Defaults defaults;
    private int offsetForAlternativePaging = 0;
    private String repositoryFolderPath;
    private TypeDeclarations typeDeclarations;
    private UrlAlias urlAlias;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="typeDeclarations are partially filled at runtime")
    public CudamiConfig(@JsonProperty(value="defaults") Defaults defaults, @JsonProperty(value="offsetForAlternativePaging") int offsetForAlternativePaging, @JsonProperty(value="repositoryFolderPath") String repositoryFolderPath, @JsonProperty(value="typeDeclarations") TypeDeclarations typeDeclarations, @JsonProperty(value="urlAlias") UrlAlias urlAlias) {
        if (defaults == null) {
            throw new IllegalStateException("Required `cudami.defaults` configuration missing.");
        }
        this.defaults = defaults;
        this.offsetForAlternativePaging = offsetForAlternativePaging;
        if (!StringUtils.hasText((String)repositoryFolderPath)) {
            throw new IllegalStateException("Required `cudami.repositoryFolderPath` configuration missing.");
        }
        this.repositoryFolderPath = repositoryFolderPath.replace("~/", System.getProperty("user.home") + "/");
        this.typeDeclarations = typeDeclarations;
        this.urlAlias = urlAlias;
    }

    public Defaults getDefaults() {
        return this.defaults;
    }

    public int getOffsetForAlternativePaging() {
        return this.offsetForAlternativePaging;
    }

    public String getRepositoryFolderPath() {
        return this.repositoryFolderPath;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="partially filled at runtime")
    public TypeDeclarations getTypeDeclarations() {
        return this.typeDeclarations;
    }

    public UrlAlias getUrlAlias() {
        return new UrlAlias(this.urlAlias);
    }

    public static class Defaults {
        private String language;
        private Locale locale;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        public Defaults(@JsonProperty(value="language") String language, @JsonProperty(value="locale") Locale locale) {
            if (!StringUtils.hasText((String)language)) {
                throw new IllegalStateException("Required `cudami.defaults.language` configuration missing.");
            }
            this.language = language;
            if (!StringUtils.hasText((String)locale.getLanguage())) {
                throw new IllegalStateException("Required `cudami.defaults.locale` configuration missing.");
            }
            this.locale = locale;
        }

        public String getLanguage() {
            return this.language;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }

    public static class UrlAlias {
        private static final int DB_MAX_LENGTH = 256;
        private List<String> generationExcludes;
        private int maxLength = -1;

        public UrlAlias() {
        }

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"}, justification="Application must not start with an invalid configuration")
        public UrlAlias(@JsonProperty(value="generationExcludes") List<String> generationExcludes, @JsonProperty(value="maxLength") int maxLength) {
            List<String> list = this.generationExcludes = generationExcludes != null ? List.copyOf(generationExcludes) : Collections.EMPTY_LIST;
            if (maxLength > 256) {
                throw new RuntimeException("The maxLength you configured is invalid, because it is greater than 256 (this is the greatest possible length in the database)!");
            }
            this.maxLength = maxLength;
        }

        public UrlAlias(UrlAlias other) {
            this.generationExcludes = other.generationExcludes;
            this.maxLength = other.maxLength;
        }

        public List<String> getGenerationExcludes() {
            return List.copyOf(this.generationExcludes);
        }

        public void setGenerationExcludes(List<String> generationExcludes) {
            this.generationExcludes = generationExcludes != null ? List.copyOf(generationExcludes) : null;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }
    }
}

