/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.lobid.client.mapper;

import de.digitalcollections.cudami.lobid.client.mapper.DateUtil;
import de.digitalcollections.lobid.model.LobidCorporateBody;
import de.digitalcollections.lobid.model.LobidDepiction;
import de.digitalcollections.lobid.model.LobidEntity;
import de.digitalcollections.lobid.model.LobidEvent;
import de.digitalcollections.lobid.model.LobidGeoLocation;
import de.digitalcollections.lobid.model.LobidGeometry;
import de.digitalcollections.lobid.model.LobidHomepage;
import de.digitalcollections.lobid.model.LobidPerson;
import de.digitalcollections.lobid.model.LobidSubject;
import de.digitalcollections.lobid.model.LobidWork;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.geo.CoordinateLocation;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Event;
import de.digitalcollections.model.identifiable.entity.NamedEntity;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.entity.agent.Person;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocation;
import de.digitalcollections.model.identifiable.entity.geo.location.HumanSettlement;
import de.digitalcollections.model.identifiable.entity.work.Work;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.semantic.Subject;
import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.text.Title;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;

public class Lobid2DCModelMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(Lobid2DCModelMapper.class);

    private static byte calculateDatePrecision(String dateStr) {
        int numberOfX = StringUtils.countMatches((CharSequence)dateStr.toUpperCase(Locale.ROOT), (CharSequence)"X");
        switch (numberOfX) {
            case 0: {
                return 9;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 6;
            }
        }
        return 0;
    }

    private static String fixForEndDate(String endDate) {
        return endDate.replaceAll("[xX]", "9").replaceAll("[^0-9-]", "");
    }

    private static String fixForStartDate(String startDate) {
        return startDate.replaceAll("[xX]", "0").replaceAll("[^0-9-]", "");
    }

    private static ImageFileResource mapDepictionToImageFileResource(List<LobidDepiction> depiction) {
        if (depiction != null && !depiction.isEmpty()) {
            String thumbnailUrl = depiction.get(0).getThumbnail();
            ImageFileResource imageFileResource = new ImageFileResource();
            imageFileResource.setUri(URI.create(thumbnailUrl));
            imageFileResource.setMimeType(MimeType.MIME_IMAGE);
            return imageFileResource;
        }
        return null;
    }

    private static URL mapHomepageToUrl(List<LobidHomepage> homepage) {
        if (homepage != null && !homepage.isEmpty()) {
            String homepageId = homepage.get(0).getId();
            try {
                return URI.create(homepageId).toURL();
            }
            catch (MalformedURLException ex) {
                LOGGER.warn("Invalid homepage URL: " + homepageId);
            }
        }
        return null;
    }

    public static CorporateBody mapToCorporateBody(LobidCorporateBody lobidCorporateBody, CorporateBody corporateBody) {
        if (corporateBody == null) {
            corporateBody = new CorporateBody();
        }
        Lobid2DCModelMapper.mapToIdentifiable((LobidEntity)lobidCorporateBody, (Identifiable)corporateBody);
        Lobid2DCModelMapper.mapToNamedEntity((LobidEntity)lobidCorporateBody, (NamedEntity)corporateBody);
        Object label = lobidCorporateBody.getPreferredName();
        List abbreviatedNameForTheCorporateBody = lobidCorporateBody.getAbbreviatedNameForTheCorporateBody();
        if (label != null && abbreviatedNameForTheCorporateBody != null) {
            label = (String)label + " (" + (String)abbreviatedNameForTheCorporateBody.get(0) + ")";
        }
        corporateBody.setLabel(new LocalizedText(Locale.GERMAN, (String)label));
        List depiction = lobidCorporateBody.getDepiction();
        ImageFileResource imageFileResource = Lobid2DCModelMapper.mapDepictionToImageFileResource(depiction);
        if (imageFileResource != null) {
            imageFileResource.setLabel(new LocalizedText(Locale.GERMAN, "Logo " + (String)label));
            corporateBody.setPreviewImage(imageFileResource);
        }
        List homepage = lobidCorporateBody.getHomepage();
        URL homepageUrl = Lobid2DCModelMapper.mapHomepageToUrl(homepage);
        corporateBody.setHomepageUrl(homepageUrl);
        return corporateBody;
    }

    public static Event mapToEvent(LobidEvent lobidEvent, Event event) {
        if (event == null) {
            event = new Event();
        }
        Lobid2DCModelMapper.mapToIdentifiable((LobidEntity)lobidEvent, (Identifiable)event);
        Lobid2DCModelMapper.mapToNamedEntity((LobidEntity)lobidEvent, (NamedEntity)event);
        return event;
    }

    public static GeoLocation mapToGeoLocation(LobidGeoLocation lobidGeoLocation, GeoLocation geoLocation) {
        if (geoLocation == null) {
            geoLocation = new GeoLocation();
        }
        Lobid2DCModelMapper.mapToIdentifiable((LobidEntity)lobidGeoLocation, (Identifiable)geoLocation);
        Lobid2DCModelMapper.mapToNamedEntity((LobidEntity)lobidGeoLocation, (NamedEntity)geoLocation);
        List depiction = lobidGeoLocation.getDepiction();
        ImageFileResource imageFileResource = Lobid2DCModelMapper.mapDepictionToImageFileResource(depiction);
        if (imageFileResource != null) {
            imageFileResource.setLabel(geoLocation.getLabel());
            geoLocation.setPreviewImage(imageFileResource);
        }
        if (lobidGeoLocation.getHasGeometry() != null && !lobidGeoLocation.getHasGeometry().isEmpty()) {
            LobidGeometry lobidGeometry = (LobidGeometry)lobidGeoLocation.getHasGeometry().get(0);
            try {
                CoordinateLocation coordinateLocation = Lobid2DCModelMapper.mapGeometryToCoordinateLocation(lobidGeometry);
                geoLocation.setCoordinateLocation(coordinateLocation);
            }
            catch (Exception e) {
                LOGGER.warn("Can not parse CoordinateLocation from LobidGeometry " + lobidGeometry, (Throwable)e);
            }
        }
        return geoLocation;
    }

    public static CoordinateLocation mapGeometryToCoordinateLocation(LobidGeometry lobidGeometry) {
        if ("Point".equals(lobidGeometry.getType()) && lobidGeometry.getAsWKT() != null) {
            String wkt = lobidGeometry.getAsWKT()[0];
            wkt = wkt.substring(wkt.indexOf("(") + 1, wkt.indexOf(")")).trim();
            String longitude = wkt.split(" ")[0];
            Double lon = Double.parseDouble(longitude);
            String latitude = wkt.split(" ")[1];
            Double lat = Double.parseDouble(latitude);
            CoordinateLocation cl = new CoordinateLocation(lat, lon, Double.valueOf(0.0), Double.valueOf(1.0E-6));
            return cl;
        }
        return null;
    }

    public static HumanSettlement mapToHumanSettlement(LobidGeoLocation lobidGeoLocation, HumanSettlement humanSettlement) {
        if (humanSettlement == null) {
            humanSettlement = new HumanSettlement();
        }
        Lobid2DCModelMapper.mapToGeoLocation(lobidGeoLocation, (GeoLocation)humanSettlement);
        return humanSettlement;
    }

    public static Identifiable mapToIdentifiable(LobidEntity lobidEntity, Identifiable identifiable) {
        String gndIdentifier;
        if (identifiable == null) {
            identifiable = new Identifiable();
        }
        if ((gndIdentifier = lobidEntity.getGndIdentifier()) != null) {
            identifiable.addIdentifier((Identifier)Identifier.builder().namespace("gnd").id(gndIdentifier).build());
        }
        String label = lobidEntity.getPreferredName();
        identifiable.setLabel(new LocalizedText(Locale.GERMAN, label));
        return identifiable;
    }

    public static NamedEntity mapToNamedEntity(LobidEntity lobidEntity, NamedEntity namedEntity) {
        if (namedEntity == null) {
            throw new IllegalArgumentException("NamedEntity must not be null");
        }
        String name = lobidEntity.getPreferredName();
        namedEntity.setName(new LocalizedText(Locale.GERMAN, name));
        return namedEntity;
    }

    public static Person mapToPerson(LobidPerson lobidPerson, Person person) {
        List depiction;
        ImageFileResource imageFileResource;
        String dateOfDeath;
        if (person == null) {
            person = new Person();
        }
        Lobid2DCModelMapper.mapToIdentifiable((LobidEntity)lobidPerson, (Identifiable)person);
        Lobid2DCModelMapper.mapToNamedEntity((LobidEntity)lobidPerson, (NamedEntity)person);
        String dateOfBirth = lobidPerson.getDateOfBirth();
        if (dateOfBirth != null && !dateOfBirth.isBlank()) {
            byte precision = Lobid2DCModelMapper.calculateDatePrecision(dateOfBirth);
            dateOfBirth = Lobid2DCModelMapper.fixForStartDate(dateOfBirth);
            person.setDateOfBirth(DateUtil.extractFilledStartDate(dateOfBirth));
            try {
                person.setTimeValueOfBirth((TimeValue)DateUtil.extractTimeValue(dateOfBirth, precision));
            }
            catch (ParseException e) {
                LOGGER.warn("Can not set TimeValue of birth.", (Throwable)e);
            }
        }
        if ((dateOfDeath = lobidPerson.getDateOfDeath()) != null && !dateOfDeath.isBlank()) {
            byte precision = Lobid2DCModelMapper.calculateDatePrecision(dateOfDeath);
            dateOfDeath = Lobid2DCModelMapper.fixForEndDate(dateOfDeath);
            person.setDateOfDeath(DateUtil.extractFilledEndDate(dateOfDeath));
            try {
                person.setTimeValueOfDeath((TimeValue)DateUtil.extractTimeValue(dateOfDeath, precision));
            }
            catch (ParseException e) {
                LOGGER.warn("Can not set TimeValue of death.", (Throwable)e);
            }
        }
        if ((imageFileResource = Lobid2DCModelMapper.mapDepictionToImageFileResource(depiction = lobidPerson.getDepiction())) != null) {
            imageFileResource.setLabel(person.getLabel());
            person.setPreviewImage(imageFileResource);
        }
        return person;
    }

    public static Subject mapToSubject(LobidSubject lobidSubject, Subject subject) {
        if (subject == null) {
            subject = new Subject();
        }
        Lobid2DCModelMapper.mapToIdentifiable((LobidEntity)lobidSubject, (Identifiable)subject);
        return subject;
    }

    public static Work mapToWork(LobidWork lobidWork, Work work) {
        if (work == null) {
            work = new Work();
        }
        Lobid2DCModelMapper.mapToIdentifiable((LobidEntity)lobidWork, (Identifiable)work);
        work.setTitles(List.of(Title.builder().text(work.getLabel()).build()));
        return work;
    }
}

