/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.lobid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.lobid.client.LobidBaseClient;
import de.digitalcollections.cudami.lobid.client.model.LobidCorporateBody;
import de.digitalcollections.cudami.lobid.client.model.LobidDepiction;
import de.digitalcollections.cudami.lobid.client.model.LobidHomepage;
import de.digitalcollections.model.exception.http.HttpException;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.text.LocalizedText;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LobidCorporateBodiesClient
extends LobidBaseClient<LobidCorporateBody> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LobidCorporateBodiesClient.class);

    LobidCorporateBodiesClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, LobidCorporateBody.class, mapper);
    }

    public CorporateBody getByGndId(String gndId) throws HttpException {
        LobidCorporateBody lobidCorporateBody = (LobidCorporateBody)this.doGetRequestForObject(String.format("/gnd/%s.json", gndId));
        CorporateBody corporateBody = this.mapLobidToModel(lobidCorporateBody);
        return corporateBody;
    }

    private CorporateBody mapLobidToModel(LobidCorporateBody lobidCorporateBody) {
        List<LobidDepiction> depiction;
        List<LobidHomepage> homepage;
        CorporateBody corporateBody = new CorporateBody();
        Object labelText = lobidCorporateBody.getPreferredName();
        List<String> abbreviatedNameForTheCorporateBody = lobidCorporateBody.getAbbreviatedNameForTheCorporateBody();
        if (labelText != null && abbreviatedNameForTheCorporateBody != null) {
            labelText = (String)labelText + " (" + abbreviatedNameForTheCorporateBody.get(0) + ")";
        }
        corporateBody.setLabel(new LocalizedText(Locale.GERMAN, (String)labelText));
        String gndIdentifier = lobidCorporateBody.getGndIdentifier();
        if (gndIdentifier != null) {
            corporateBody.addIdentifier(new Identifier(null, "gnd", gndIdentifier));
        }
        if ((homepage = lobidCorporateBody.getHomepage()) != null && !homepage.isEmpty()) {
            String homepageId = homepage.get(0).getId();
            try {
                corporateBody.setHomepageUrl(URI.create(homepageId).toURL());
            }
            catch (MalformedURLException ex) {
                LOGGER.warn("Invalid homepage URL: " + homepageId);
            }
        }
        if ((depiction = lobidCorporateBody.getDepiction()) != null && !depiction.isEmpty()) {
            String thumbnailUrl = depiction.get(0).getThumbnail();
            ImageFileResource previewImage = new ImageFileResource();
            previewImage.setLabel(new LocalizedText(Locale.GERMAN, "Logo " + (String)labelText));
            previewImage.setUri(URI.create(thumbnailUrl));
            previewImage.setMimeType(MimeType.MIME_IMAGE);
            corporateBody.setPreviewImage(previewImage);
        }
        return corporateBody;
    }
}

