/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.lobid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import de.digitalcollections.model.api.http.exceptions.HttpErrorDecoder;
import de.digitalcollections.model.api.http.exceptions.HttpException;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LobidBaseClient<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LobidBaseClient.class);
    protected final HttpClient http;
    protected final ObjectMapper mapper;
    protected final ObjectReader reader;
    protected final URI serverUri;
    protected final Class<T> targetType;

    public LobidBaseClient(HttpClient http, String serverUrl, Class<T> targetType, ObjectMapper mapper) {
        this.http = http;
        this.mapper = mapper;
        this.reader = mapper.reader().forType(targetType);
        this.serverUri = URI.create(serverUrl);
        this.targetType = targetType;
    }

    protected URI createFullUri(String requestUrl) {
        return this.serverUri.resolve(this.serverUri.getPath() + requestUrl);
    }

    private HttpRequest createGetRequest(String requestUrl) {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("GET " + url);
        HttpRequest req = HttpRequest.newBuilder().GET().uri(url).header("Accept", "application/json").build();
        return req;
    }

    protected T doGetRequestForObject(String requestUrl) throws HttpException {
        return (T)this.doGetRequestForObject(requestUrl, this.targetType);
    }

    protected Object doGetRequestForObject(String requestUrl, Class<?> targetType) throws HttpException {
        HttpRequest req = this.createGetRequest(requestUrl);
        try {
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("GET " + requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            Object result = this.mapper.readerFor(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.warn("Failed to retrieve response due to connection error", (Throwable)e);
            throw HttpErrorDecoder.decode((String)("GET " + requestUrl), (int)500, null);
        }
    }

    protected List doGetRequestForObjectList(String requestUrl, Class<?> targetType) throws HttpException {
        HttpRequest req = this.createGetRequest(requestUrl);
        try {
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("GET " + requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            List result = (List)this.mapper.readerForListOf(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.warn("Failed to retrieve response due to connection error", (Throwable)e);
            throw HttpErrorDecoder.decode((String)("GET " + requestUrl), (int)500, null);
        }
    }

    protected String doGetRequestForString(String requestUrl) throws HttpException {
        HttpRequest req = this.createGetRequest(requestUrl);
        try {
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("GET " + requestUrl), (int)statusCode, response);
            }
            String body = response.body();
            return body;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.warn("Failed to retrieve response due to connection error", (Throwable)e);
            throw HttpErrorDecoder.decode((String)("GET " + requestUrl), (int)500, null);
        }
    }
}

