/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.view;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.AbstractUniqueObjectController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiRestClient;
import de.digitalcollections.cudami.client.view.CudamiRenderingTemplatesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.view.RenderingTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"renderingTemplate"})
public class RenderingTemplatesController
extends AbstractUniqueObjectController<RenderingTemplate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderingTemplatesController.class);
    private final MessageSource messageSource;

    public RenderingTemplatesController(CudamiClient client, LanguageService languageService, MessageSource messageSource) {
        super((CudamiRestClient)client.forRenderingTemplates(), languageService);
        this.messageSource = messageSource;
    }

    @GetMapping(value={"/renderingtemplates/new"})
    public String create(Model model) throws TechnicalException {
        RenderingTemplate renderingTemplate = (RenderingTemplate)this.service.create();
        Locale defaultLanguage = this.languageService.getDefaultLanguage();
        renderingTemplate.setDescription(new LocalizedText(defaultLanguage, ""));
        renderingTemplate.setLabel(new LocalizedText(defaultLanguage, ""));
        model.addAttribute("renderingTemplate", (Object)renderingTemplate);
        List<Locale> existingLanguages = List.of(defaultLanguage);
        List sortedLanguages = this.languageService.getAllLanguages();
        model.addAttribute("existingLanguages", existingLanguages);
        model.addAttribute("allLanguages", (Object)sortedLanguages);
        model.addAttribute("activeLanguage", (Object)defaultLanguage);
        model.addAttribute("mode", (Object)"create");
        return "renderingtemplates/create-or-edit";
    }

    @GetMapping(value={"/renderingtemplates/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        RenderingTemplate template = (RenderingTemplate)this.service.getByUuid(uuid);
        if (template == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("renderingTemplate", (Object)template);
        Set existingLanguages = this.getExistingLanguages(template);
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.toArray()[0]);
        }
        List sortedLanguages = this.languageService.getAllLanguages();
        model.addAttribute("allLanguages", (Object)sortedLanguages);
        model.addAttribute("mode", (Object)"edit");
        return "renderingtemplates/create-or-edit";
    }

    private Set<Locale> getExistingLanguages(RenderingTemplate template) throws TechnicalException {
        Locale defaultLanguage = this.languageService.getDefaultLanguage();
        LocalizedText label = template.getLabel();
        LocalizedText description = template.getDescription();
        LinkedHashSet<Locale> existingLanguages = new LinkedHashSet<Locale>();
        if (CollectionUtils.isEmpty((Map)label) && CollectionUtils.isEmpty((Map)description)) {
            existingLanguages.add(defaultLanguage);
        } else {
            if (!CollectionUtils.isEmpty((Map)label)) {
                existingLanguages.addAll(label.getLocales());
            }
            if (!CollectionUtils.isEmpty((Map)description)) {
                existingLanguages.addAll(description.getLocales());
            }
        }
        Locale displayLocale = LocaleContextHolder.getLocale();
        existingLanguages = new LinkedHashSet(this.languageService.sortLanguages(displayLocale, existingLanguages));
        return existingLanguages;
    }

    @GetMapping(value={"/renderingtemplates"})
    public String list(Model model) throws TechnicalException {
        List existingLanguages = this.languageService.getExistingLanguagesForLocales(((CudamiRenderingTemplatesClient)this.service).getLanguages());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "renderingtemplates/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "renderingtemplates";
    }

    @PostMapping(value={"/renderingtemplates/new"})
    public String save(@ModelAttribute @Valid RenderingTemplate renderingTemplate, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        model.addAttribute("mode", (Object)"create");
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "renderingtemplates/create-or-edit";
        }
        try {
            this.service.save((UniqueObject)renderingTemplate);
            LOGGER.info("Successfully saved rendering template");
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save rendering template: ", (Throwable)e);
            String message = this.messageSource.getMessage("error.technical_error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/renderingtemplates";
        }
        if (results.hasErrors()) {
            return "renderingtemplates/create-or-edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/renderingtemplates";
    }

    @PostMapping(value={"/renderingtemplates/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String update(@PathVariable UUID uuid, @ModelAttribute(value="formData") RenderingTemplate renderingTemplateFormData, @ModelAttribute RenderingTemplate renderingTemplate, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws TechnicalException {
        model.addAttribute("mode", (Object)"edit");
        this.verifyBinding(results);
        renderingTemplate.setLabel(renderingTemplateFormData.getLabel());
        renderingTemplate.setDescription(renderingTemplateFormData.getDescription());
        if (results.hasErrors()) {
            Set existingLanguages = this.getExistingLanguages(renderingTemplate);
            model.addAttribute("existingLanguages", (Object)existingLanguages);
            model.addAttribute("activeLanguage", (Object)this.languageService.getDefaultLanguage());
            model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
            return "renderingtemplates/create-or-edit";
        }
        try {
            this.service.update(uuid, (UniqueObject)renderingTemplate);
        }
        catch (TechnicalException e) {
            String message = "Cannot update renderingTemplate with uuid=" + uuid + ": " + e;
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/renderingtemplates/" + uuid + "/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/renderingtemplates/" + uuid;
    }

    @GetMapping(value={"/renderingtemplates/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        String dataLanguage;
        RenderingTemplate renderingTemplate = (RenderingTemplate)this.service.getByUuid(uuid);
        if (renderingTemplate == null) {
            throw new ResourceNotFoundException();
        }
        List existingLanguages = Collections.emptyList();
        LocalizedText label = renderingTemplate.getLabel();
        if (!CollectionUtils.isEmpty((Map)label)) {
            Locale displayLocale = LocaleContextHolder.getLocale();
            existingLanguages = this.languageService.sortLanguages(displayLocale, (Collection)label.getLocales());
        }
        if ((dataLanguage = targetDataLanguage) == null && this.languageService != null) {
            dataLanguage = this.languageService.getDefaultLanguage().getLanguage();
        }
        model.addAttribute("renderingTemplate", (Object)renderingTemplate).addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        return "renderingtemplates/view";
    }
}

