/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.model.security;

import de.digitalcollections.model.security.User;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class AuthenticatedUser
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private final User user;

    @SuppressFBWarnings
    public AuthenticatedUser(User user) {
        this.user = user;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.user.getRoles().stream().map(r -> (GrantedAuthority & Serializable)() -> "ROLE_" + r.name()).collect(Collectors.toList());
    }

    public String getPassword() {
        return this.user.getPasswordHash();
    }

    public String getUsername() {
        return this.user.getEmail();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }
}

