/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.semantic;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.AbstractUniqueObjectController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiRestClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.semantic.Headword;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class HeadwordsController
extends AbstractUniqueObjectController<Headword> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadwordsController.class);

    public HeadwordsController(CudamiClient client, LanguageService languageService) {
        super((CudamiRestClient)client.forHeadwords(), languageService);
    }

    @GetMapping(value={"/headwords/new"})
    public String create(Model model) throws TechnicalException {
        model.addAttribute("activeLanguage", (Object)this.languageService.getDefaultLanguage());
        return "headwords/create";
    }

    @GetMapping(value={"/headwords/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        Headword headword = (Headword)this.service.getByUuid(uuid);
        if (headword == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("headword", (Object)headword);
        return "headwords/edit";
    }

    @GetMapping(value={"/headwords"})
    public String list(Model model) throws TechnicalException {
        return "headwords/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "headwords";
    }

    @GetMapping(value={"/headwords/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, Model model) throws TechnicalException, ResourceNotFoundException {
        Headword headword = (Headword)this.service.getByUuid(uuid);
        if (headword == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("headword", (Object)headword);
        return "headwords/view";
    }
}

