/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.semantic;

import de.digitalcollections.cudami.admin.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.admin.controller.AbstractUniqueObjectController;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTResponse;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiRestClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.semantic.Headword;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HeadwordsAPIController
extends AbstractUniqueObjectController<Headword> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadwordsAPIController.class);

    public HeadwordsAPIController(CudamiClient client) {
        super((CudamiRestClient)client.forHeadwords(), null);
    }

    @GetMapping(value={"/api/headwords/new"})
    @ResponseBody
    public Headword createModel() throws TechnicalException {
        return (Headword)this.service.create();
    }

    @GetMapping(value={"/api/headwords"})
    @ResponseBody
    @SuppressFBWarnings
    public BTResponse<Headword> find(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder) throws TechnicalException, ServiceException {
        return this.find(Headword.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, null);
    }

    @GetMapping(value={"/api/headwords/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    @ResponseBody
    public Headword getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (Headword)this.service.getByUuid(uuid);
    }
}

