/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.AbstractUniqueObjectController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiRestClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.IdentifierType;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"identifierType"})
public class IdentifierTypeController
extends AbstractUniqueObjectController<IdentifierType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierTypeController.class);
    private final MessageSource messageSource;

    public IdentifierTypeController(CudamiClient client, LanguageService languageService, MessageSource messageSource) {
        super((CudamiRestClient)client.forIdentifierTypes(), languageService);
        this.messageSource = messageSource;
    }

    @GetMapping(value={"/identifiertypes/new"})
    public String create(Model model) throws TechnicalException {
        IdentifierType identifierType = (IdentifierType)this.service.create();
        model.addAttribute("identifierType", (Object)identifierType);
        model.addAttribute("mode", (Object)"create");
        return "identifiertypes/create-or-edit";
    }

    @GetMapping(value={"/identifiertypes/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) throws TechnicalException, ResourceNotFoundException {
        IdentifierType identifierType = (IdentifierType)this.service.getByUuid(uuid);
        if (identifierType == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("identifierType", (Object)identifierType);
        model.addAttribute("mode", (Object)"edit");
        return "identifiertypes/create-or-edit";
    }

    @GetMapping(value={"/identifiertypes"})
    public String list() {
        return "identifiertypes/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "identifiertypes";
    }

    @PostMapping(value={"/identifiertypes/new"})
    public String save(@ModelAttribute @Valid IdentifierType identifierType, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        model.addAttribute("mode", (Object)"create");
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "identifiertypes/create-or-edit";
        }
        try {
            this.service.save((UniqueObject)identifierType);
            LOGGER.info("Successfully saved identifier type");
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save identifier type: ", (Throwable)e);
            String message = this.messageSource.getMessage("error.technical_error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/identifiertypes";
        }
        if (results.hasErrors()) {
            return "identifiertypes/create-or-edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/identifiertypes";
    }

    @PostMapping(value={"/identifiertypes/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String update(@PathVariable UUID uuid, @ModelAttribute @Valid IdentifierType identifierType, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws TechnicalException {
        model.addAttribute("mode", (Object)"edit");
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "identifiertypes/create-or-edit";
        }
        try {
            this.service.update(uuid, (UniqueObject)identifierType);
        }
        catch (TechnicalException e) {
            String message = "Cannot update identifierType with uuid=" + uuid + ": " + e;
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/identifiertypes/" + uuid + "/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/identifiertypes/" + uuid;
    }

    @GetMapping(value={"/identifiertypes/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, Model model) throws TechnicalException, ResourceNotFoundException {
        IdentifierType identifierType = (IdentifierType)this.service.getByUuid(uuid);
        if (identifierType == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("identifierType", (Object)identifierType);
        return "identifiertypes/view";
    }
}

