/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.advice;

import de.digitalcollections.cudami.admin.propertyeditor.RoleEditor;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.security.Role;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyEditor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;

@ControllerAdvice
public class GlobalControllerAdvice {
    private final RoleEditor roleEditor;
    private final String version;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public GlobalControllerAdvice(RoleEditor roleEditor, @Value(value="${info.app.project.version}") String version) {
        this.roleEditor = roleEditor;
        this.version = version;
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public String handleResourceNotFoundException(Model model) {
        return "error/404";
    }

    @InitBinder
    public void registerCustomEditors(WebDataBinder binder, WebRequest request) {
        binder.registerCustomEditor(Role.class, (PropertyEditor)this.roleEditor);
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(true));
    }

    @ModelAttribute(value="version")
    public String getVersion() {
        return this.version;
    }
}

