/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTRequest;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import de.digitalcollections.model.text.LocalizedText;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.reflect.FieldUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@SuppressFBWarnings
public abstract class AbstractPagingAndSortingController
extends AbstractController {
    protected final LanguageService languageService;

    public AbstractPagingAndSortingController(LanguageService languageService) {
        this.languageService = languageService;
    }

    protected BTRequest createBTRequest(Class targetClass, int offset, int limit, String sortProperty, String sortOrder, String searchProperty, String searchTerm, String dataLanguage) throws TechnicalException, IllegalArgumentException {
        BTRequest btRequest = new BTRequest(offset, limit);
        Sorting sorting = this.createSorting(targetClass, sortProperty, sortOrder, dataLanguage);
        btRequest.setSorting(sorting);
        Filtering filtering = this.createFiltering(targetClass, searchProperty, searchTerm, dataLanguage);
        btRequest.setFiltering(filtering);
        return btRequest;
    }

    private Filtering createFiltering(Class targetClass, String searchProperty, String searchTerm, String dataLanguage) throws TechnicalException {
        Filtering filtering = null;
        if (searchProperty != null && searchTerm != null && targetClass != null) {
            Object expression = searchProperty;
            if (this.isMultiLanguageField(targetClass, searchProperty)) {
                dataLanguage = this.getDataLanguage(dataLanguage, this.languageService);
                expression = (String)expression + "." + dataLanguage;
            }
            filtering = Filtering.builder().add(FilterCriterion.builder().withExpression((String)expression).contains((Object)searchTerm).build()).build();
        }
        return filtering;
    }

    @SuppressFBWarnings
    protected PageRequest createPageRequest(Class targetClass, int pageNumber, int pageSize, String sortProperty, String sortOrder, String searchProperty, String searchTerm, String dataLanguage) throws TechnicalException {
        PageRequest pageRequest = new PageRequest(pageNumber, pageSize);
        Sorting sorting = this.createSorting(targetClass, sortProperty, sortOrder, dataLanguage);
        pageRequest.setSorting(sorting);
        Filtering filtering = this.createFiltering(targetClass, searchProperty, searchTerm, dataLanguage);
        pageRequest.setFiltering(filtering);
        return pageRequest;
    }

    @SuppressFBWarnings
    protected PageRequest createPageRequest(Class targetClass, int pageNumber, int pageSize, List<Order> sortBy, String searchProperty, String searchTerm, String dataLanguage) throws TechnicalException {
        PageRequest pageRequest = new PageRequest(pageNumber, pageSize);
        Sorting sorting = this.createSorting(targetClass, sortBy, dataLanguage);
        pageRequest.setSorting(sorting);
        Filtering filtering = this.createFiltering(targetClass, searchProperty, searchTerm, dataLanguage);
        pageRequest.setFiltering(filtering);
        return pageRequest;
    }

    private Sorting createSorting(Class targetClass, String sortProperty, String sortOrder, String dataLanguage) throws TechnicalException {
        String sortLanguage = null;
        if (this.isMultiLanguageField(targetClass, sortProperty)) {
            sortLanguage = this.getDataLanguage(dataLanguage, this.languageService);
        }
        List<Order> orders = List.of(Order.builder().property(sortProperty).subProperty(sortLanguage).direction(Direction.fromString((String)sortOrder)).build());
        Sorting sorting = new Sorting(orders);
        return sorting;
    }

    private Sorting createSorting(Class targetClass, List<Order> sortBy, String dataLanguage) throws TechnicalException {
        if (sortBy != null) {
            String sortLanguage = this.getDataLanguage(dataLanguage, this.languageService);
            for (Order order : sortBy) {
                String sortProperty = order.getProperty();
                if (!this.isMultiLanguageField(targetClass, sortProperty)) continue;
                order.setSubProperty(sortLanguage);
            }
            return new Sorting(sortBy);
        }
        return null;
    }

    protected String getDataLanguage(String targetDataLanguage, LanguageService languageService) throws TechnicalException {
        return this.getDataLanguage(targetDataLanguage, null, languageService);
    }

    protected String getDataLanguage(String targetDataLanguage, List<Locale> existingLanguages, LanguageService languageService) throws TechnicalException {
        String dataLanguage = targetDataLanguage;
        if (dataLanguage == null && languageService != null) {
            dataLanguage = languageService.getDefaultLanguage().getLanguage();
        }
        if (existingLanguages != null && !existingLanguages.isEmpty() && !existingLanguages.contains(Locale.forLanguageTag(dataLanguage))) {
            dataLanguage = existingLanguages.get(0).toLanguageTag();
        }
        return dataLanguage;
    }

    private boolean isMultiLanguageField(Class clz, String fieldName) throws TechnicalException {
        try {
            Class fieldType = AbstractPagingAndSortingController.getFieldType((Class)clz, (String)fieldName);
            return LocalizedText.class == fieldType || LocalizedStructuredContent.class == fieldType;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new TechnicalException("Field " + fieldName + " not found in class " + clz.getSimpleName(), (Throwable)e);
        }
    }

    public static Class getFieldType(Class clz, String fieldName) throws NoSuchFieldException {
        Field field = FieldUtils.getField((Class)clz, (String)fieldName, (boolean)true);
        if (field == null) {
            throw new NoSuchFieldException();
        }
        return field.getType();
    }
}

