/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.legal;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.business.impl.validator.LabelNotBlankValidator;
import de.digitalcollections.cudami.admin.controller.AbstractUniqueObjectController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiRestClient;
import de.digitalcollections.cudami.client.legal.CudamiLicensesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.legal.License;
import de.digitalcollections.model.text.LocalizedText;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"license"})
public class LicensesController
extends AbstractUniqueObjectController<License> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicensesController.class);
    private final LabelNotBlankValidator labelNotBlankValidator;
    private final MessageSource messageSource;

    public LicensesController(CudamiClient client, LanguageService languageService, MessageSource messageSource, LabelNotBlankValidator labelNotBlankValidator) {
        super((CudamiRestClient)client.forLicenses(), languageService);
        this.labelNotBlankValidator = labelNotBlankValidator;
        this.messageSource = messageSource;
    }

    @GetMapping(value={"/licenses/new"})
    public String create(Model model) throws TechnicalException {
        License license = (License)this.service.create();
        Locale defaultLanguage = this.languageService.getDefaultLanguage();
        license.setLabel(new LocalizedText(defaultLanguage, ""));
        model.addAttribute("license", (Object)license);
        List<Locale> existingLanguages = List.of(defaultLanguage);
        List sortedLanguages = this.languageService.getAllLanguages();
        model.addAttribute("existingLanguages", existingLanguages);
        model.addAttribute("allLanguages", (Object)sortedLanguages);
        model.addAttribute("activeLanguage", (Object)defaultLanguage);
        model.addAttribute("mode", (Object)"create");
        return "licenses/create-or-edit";
    }

    @GetMapping(value={"/licenses/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        License license = (License)this.service.getByUuid(uuid);
        if (license == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("license", (Object)license);
        List existingLanguages = this.languageService.getExistingLanguages(this.languageService.getDefaultLanguage(), license.getLabel());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
        model.addAttribute("mode", (Object)"edit");
        return "licenses/create-or-edit";
    }

    @GetMapping(value={"/licenses"})
    public String list(Model model) throws TechnicalException {
        List existingLanguages = this.languageService.getExistingLanguagesForLocales(((CudamiLicensesClient)this.service).getLanguages());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "licenses/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "licenses";
    }

    @PostMapping(value={"/licenses/new"})
    public String save(@ModelAttribute @Valid License license, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        model.addAttribute("mode", (Object)"create");
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "licenses/create-or-edit";
        }
        try {
            this.service.save((UniqueObject)license);
            LOGGER.info("Successfully saved license");
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save license: ", (Throwable)e);
            String message = this.messageSource.getMessage("error.technical_error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/licenses";
        }
        if (results.hasErrors()) {
            return "licenses/create-or-edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/licenses";
    }

    @PostMapping(value={"/licenses/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String update(@PathVariable UUID uuid, @ModelAttribute(value="formData") License licenseFormData, @ModelAttribute License license, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws TechnicalException {
        model.addAttribute("mode", (Object)"edit");
        this.verifyBinding(results);
        license.setLabel(licenseFormData.getLabel());
        this.labelNotBlankValidator.validate((Object)license.getLabel(), (Errors)results);
        if (results.hasErrors()) {
            Locale defaultLanguage = this.languageService.getDefaultLanguage();
            model.addAttribute("existingLanguages", (Object)this.languageService.getExistingLanguages(defaultLanguage, license.getLabel()));
            model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
            model.addAttribute("activeLanguage", (Object)defaultLanguage);
            return "licenses/create-or-edit";
        }
        try {
            this.service.update(uuid, (UniqueObject)license);
        }
        catch (TechnicalException e) {
            String message = "Cannot update license with uuid=" + uuid + ": " + e;
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/licenses/" + uuid + "/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/licenses/" + uuid;
    }

    @GetMapping(value={"/licenses/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        String dataLanguage;
        License license = (License)this.service.getByUuid(uuid);
        if (license == null) {
            throw new ResourceNotFoundException();
        }
        List existingLanguages = Collections.emptyList();
        LocalizedText label = license.getLabel();
        if (!CollectionUtils.isEmpty((Map)label)) {
            Locale displayLocale = LocaleContextHolder.getLocale();
            existingLanguages = this.languageService.sortLanguages(displayLocale, (Collection)label.getLocales());
        }
        if ((dataLanguage = targetDataLanguage) == null && this.languageService != null) {
            dataLanguage = this.languageService.getDefaultLanguage().getLanguage();
        }
        model.addAttribute("license", (Object)license).addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        return "licenses/view";
    }
}

