/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.web;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.AbstractIdentifiablesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiWebsitesClient;
import de.digitalcollections.cudami.client.identifiable.web.CudamiWebpagesClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class WebpagesController
extends AbstractIdentifiablesController<Webpage, CudamiWebpagesClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpagesController.class);
    private final CudamiWebsitesClient websiteService;

    public WebpagesController(CudamiClient client, LanguageService languageService) {
        super((CudamiIdentifiablesClient)client.forWebpages(), client, languageService);
        this.websiteService = client.forWebsites();
    }

    @GetMapping(value={"/webpages/new"})
    public String create(Model model, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") UUID parentUuid) throws TechnicalException {
        model.addAttribute("activeLanguage", (Object)this.languageService.getDefaultLanguage()).addAttribute("parentType", (Object)parentType).addAttribute("parentUuid", (Object)parentUuid);
        Website website = this.getWebsite(parentUuid, parentType);
        if (website != null) {
            model.addAttribute("parentWebsite", (Object)website);
        }
        return "webpages/create";
    }

    @GetMapping(value={"/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Webpage webpage = (Webpage)this.service.getByUuid(uuid);
        List existingLanguages = this.languageService.sortLanguages(displayLocale, (Collection)webpage.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("uuid", (Object)webpage.getUuid());
        Website website = this.getWebsite(uuid, null);
        if (website != null) {
            model.addAttribute("parentWebsite", (Object)website);
        }
        return "webpages/edit";
    }

    private Website getWebsite(UUID uuid, String parentType) throws TechnicalException {
        if (parentType == null || "webpage".equals(parentType.toLowerCase())) {
            return ((CudamiWebpagesClient)this.service).getWebsite(uuid);
        }
        if ("website".equals(parentType.toLowerCase())) {
            return (Website)this.websiteService.getByUuid(uuid);
        }
        return null;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "webpages";
    }

    @GetMapping(value={"/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        Webpage webpage = (Webpage)this.service.getByUuid(uuid);
        if (webpage == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("webpage", (Object)webpage);
        List existingLanguages = this.getExistingLanguagesFromIdentifiable((Identifiable)webpage);
        String dataLanguage = this.getDataLanguage(targetDataLanguage, existingLanguages, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        List existingSubpageLanguages = this.getExistingLanguagesFromIdentifiables(webpage.getChildren());
        String dataLanguageSubpages = this.getDataLanguage(targetDataLanguage, existingSubpageLanguages, this.languageService);
        model.addAttribute("existingSubpageLanguages", (Object)existingSubpageLanguages).addAttribute("dataLanguageSubpages", (Object)dataLanguageSubpages);
        BreadcrumbNavigation breadcrumbNavigation = ((CudamiWebpagesClient)this.service).getBreadcrumbNavigation(uuid);
        List breadcrumbs = breadcrumbNavigation.getNavigationItems();
        breadcrumbs.removeIf(n -> n.getTargetId() == null);
        model.addAttribute("breadcrumbs", (Object)breadcrumbs);
        Website website = ((CudamiWebpagesClient)this.service).getWebsite(uuid);
        model.addAttribute("website", (Object)website);
        return "webpages/view";
    }
}

