/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifierTypesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.IdentifierType;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IdentifierTypeController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierTypeController.class);
    private final CudamiIdentifierTypesClient service;

    public IdentifierTypeController(CudamiClient client) {
        this.service = client.forIdentifierTypes();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "identifiertypes";
    }

    @GetMapping(value={"/identifiertypes/new"})
    public String create() {
        return "identifiertypes/create";
    }

    @GetMapping(value={"/api/identifiertypes/new"})
    @ResponseBody
    public IdentifierType createModel() throws TechnicalException {
        return (IdentifierType)this.service.create();
    }

    @GetMapping(value={"/identifiertypes/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) throws TechnicalException {
        IdentifierType identifierType = (IdentifierType)this.service.getByUuid(uuid);
        model.addAttribute("label", (Object)identifierType.getLabel());
        model.addAttribute("uuid", (Object)identifierType.getUuid());
        return "identifiertypes/edit";
    }

    @GetMapping(value={"/api/identifiertypes"})
    @ResponseBody
    public PageResponse<IdentifierType> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws TechnicalException {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        return this.service.find(pageRequest);
    }

    @GetMapping(value={"/api/identifiertypes/{uuid}"})
    @ResponseBody
    public IdentifierType getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (IdentifierType)this.service.getByUuid(uuid);
    }

    @GetMapping(value={"/identifiertypes"})
    public String list() {
        return "identifiertypes/list";
    }

    @PostMapping(value={"/api/identifiertypes"})
    public ResponseEntity save(@RequestBody IdentifierType identifierType) {
        try {
            IdentifierType identifierTypeDb = (IdentifierType)this.service.save((UniqueObject)identifierType);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)identifierTypeDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save identifier type: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/identifiertypes/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody IdentifierType identifierType) {
        try {
            IdentifierType identifierTypeDb = (IdentifierType)this.service.update(uuid, (UniqueObject)identifierType);
            return ResponseEntity.ok((Object)identifierTypeDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot update identifier type with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

