/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiArticlesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Article;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ArticlesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArticlesController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiArticlesClient service;

    public ArticlesController(LanguageSortingHelper languageSortingHelper, CudamiClient client) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = client.forLocales();
        this.service = client.forArticles();
    }

    @GetMapping(value={"/articles/new"})
    public String create(Model model) throws TechnicalException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        return "articles/create";
    }

    @GetMapping(value={"/api/articles/new"})
    @ResponseBody
    public Article create() throws TechnicalException {
        return (Article)this.service.create();
    }

    @GetMapping(value={"/articles/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Article article = (Article)this.service.getByUuid(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)article.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)article.getUuid());
        return "articles/edit";
    }

    @GetMapping(value={"/api/articles"})
    @ResponseBody
    public PageResponse<Article> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws TechnicalException {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        return this.service.find(pageRequest);
    }

    @GetMapping(value={"/api/articles/{uuid}"})
    @ResponseBody
    public Article getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (Article)this.service.getByUuid(uuid);
    }

    @GetMapping(value={"/articles"})
    public String list(Model model) throws TechnicalException {
        Locale locale = LocaleContextHolder.getLocale();
        model.addAttribute("existingLanguages", (Object)this.languageSortingHelper.sortLanguages(locale, (Collection)this.service.getLanguages()));
        return "articles/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "articles";
    }

    @PostMapping(value={"/api/articles"})
    public ResponseEntity save(@RequestBody Article article) {
        try {
            Article articleDb = (Article)this.service.save((UniqueObject)article);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)articleDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save article: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/articles/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Article article) {
        try {
            Article articleDb = (Article)this.service.update(uuid, (UniqueObject)article);
            return ResponseEntity.ok((Object)articleDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save article with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/articles/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws TechnicalException, ResourceNotFoundException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Article article = (Article)this.service.getByUuid(uuid);
        if (article == null) {
            throw new ResourceNotFoundException();
        }
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)article.getLabel().getLocales());
        List relatedFileResources = this.service.getRelatedFileResources(article.getUuid());
        model.addAttribute("article", (Object)article).addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("relatedFileResources", (Object)relatedFileResources);
        return "articles/view";
    }
}

