/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.validator;

import de.digitalcollections.cudami.admin.business.impl.validator.PasswordsValidatorParams;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.LengthRule;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.RuleResult;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class PasswordsValidator
implements Validator {
    private static final Pattern PATTERN_SPECIAL_CHAR = Pattern.compile(".*[^a-zA-Z0-9]+.*");
    private static final int PASSWORD_MIN_LENGTH = 12;
    private static final int PASSWORD_MAX_LENGTH = 30;
    private final MessageSource messageSource;

    public PasswordsValidator(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    protected boolean containsSpecialChar(String password) {
        Matcher m = PATTERN_SPECIAL_CHAR.matcher(password);
        return m.matches();
    }

    public boolean supports(Class<?> clazz) {
        return PasswordsValidatorParams.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        String password2;
        PasswordsValidatorParams passwords = (PasswordsValidatorParams)target;
        String password1 = passwords.getPassword1();
        if (!ObjectUtils.nullSafeEquals((Object)password1, (Object)(password2 = passwords.getPassword2()))) {
            String code = "error.passwords_must_be_equals";
            errors.reject(code, this.messageSource.getMessage(code, null, LocaleContextHolder.getLocale()));
            return;
        }
        String passwordHash = passwords.getPasswordHash();
        if (!StringUtils.hasText((String)passwordHash) && !StringUtils.hasText((String)password1)) {
            String code = "error.passwords_must_be_filled";
            errors.reject(code, this.messageSource.getMessage(code, null, LocaleContextHolder.getLocale()));
            return;
        }
        if (StringUtils.hasText((String)password1) && password1.length() < 12) {
            String code = "error.password_min_length";
            Object[] args = new Object[]{12};
            errors.reject(code, args, this.messageSource.getMessage(code, args, LocaleContextHolder.getLocale()));
            return;
        }
        if (StringUtils.hasText((String)password1) && password1.length() > 30) {
            String code = "error.password_max_length";
            Object[] args = new Object[]{30};
            errors.reject(code, args, this.messageSource.getMessage(code, args, LocaleContextHolder.getLocale()));
            return;
        }
        PasswordValidator validator = new PasswordValidator(Arrays.asList(new LengthRule(12, 30), new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, 1), new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, 1), new CharacterRule((CharacterData)EnglishCharacterData.Digit, 1)));
        RuleResult result = validator.validate(new PasswordData(password1));
        if (!result.isValid()) {
            String code = "error.password_too_weak";
            errors.reject(code, this.messageSource.getMessage(code, null, LocaleContextHolder.getLocale()));
            return;
        }
        if (!this.containsSpecialChar(password1)) {
            String code = "error.password_too_weak";
            errors.reject(code, this.messageSource.getMessage(code, null, LocaleContextHolder.getLocale()));
            return;
        }
    }
}

