/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.interceptors;

import de.digitalcollections.cudami.admin.business.api.service.security.UserService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

public class CreateAdminUserInterceptor
implements HandlerInterceptor,
MessageSourceAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateAdminUserInterceptor.class);
    private MessageSource messageSource;
    @Autowired
    private UserService service;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        LOGGER.info("checking if admin user exists...");
        boolean activeAdminUserExists = this.service.doesActiveAdminUserExist();
        if (!activeAdminUserExists) {
            request.setAttribute("createAdminUser", (Object)true);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        boolean createAdminUser;
        Object doCreateAdminUser = request.getAttribute("createAdminUser");
        if (doCreateAdminUser != null && (createAdminUser = ((Boolean)doCreateAdminUser).booleanValue())) {
            modelAndView.setView((View)new RedirectView("/setup/admin", true));
            String message = this.messageSource.getMessage("msg.create_a_new_admin_user", null, LocaleContextHolder.getLocale());
            FlashMap flashMap = new FlashMap();
            flashMap.put((Object)"info_message", (Object)message);
            FlashMapManager flashMapManager = RequestContextUtils.getFlashMapManager((HttpServletRequest)request);
            if (flashMapManager == null) {
                throw new IllegalStateException("FlashMapManager not found despite output FlashMap having been set");
            }
            flashMapManager.saveOutputFlashMap(flashMap, request, response);
            LOGGER.info("Admin user does not exist. Create a new administrator user.");
        }
    }
}

