/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller;

import de.digitalcollections.cudami.admin.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.admin.business.api.service.security.UserService;
import de.digitalcollections.model.security.User;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@SessionAttributes(value={"loggedInUser"})
public class MainController {
    private final UserService<User> userService;

    public MainController(UserService<User> userService) {
        this.userService = userService;
    }

    @GetMapping(value={"/login"})
    public String login(@RequestParam(value="error", defaultValue="false") boolean error, Model model) {
        model.addAttribute("error", (Object)error);
        model.addAttribute("login", (Object)true);
        return "login";
    }

    @GetMapping(value={"", "/"})
    public String printWelcome(Model model) {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof UserDetails) {
            try {
                String username = ((UserDetails)principal).getUsername();
                User user = this.userService.findByEmail(username);
                model.addAttribute("loggedInUser", (Object)user);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return "main";
    }
}

