/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.resource;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.cudami.client.identifiable.resource.CudamiFileResourcesMetadataClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.paging.Sorting;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class FileResourcesMetadataController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourcesMetadataController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiFileResourcesMetadataClient service;

    public FileResourcesMetadataController(LanguageSortingHelper languageSortingHelper, CudamiClient client) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = client.forLocales();
        this.service = client.forFileResourcesMetadata();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "fileresources";
    }

    @GetMapping(value={"/fileresources/new"})
    public String create(Model model) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        return "fileresources/create";
    }

    @GetMapping(value={"/api/fileresources/new"})
    @ResponseBody
    public FileResource create() {
        return (FileResource)this.service.create();
    }

    @GetMapping(value={"/fileresources/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        FileResource fileResource = (FileResource)this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)fileResource.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("filename", (Object)fileResource.getFilename());
        model.addAttribute("uuid", (Object)fileResource.getUuid());
        return "fileresources/edit";
    }

    @GetMapping(value={"/api/fileresources"})
    @ResponseBody
    public PageResponse<FileResource> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        return this.service.find(searchPageRequest);
    }

    @GetMapping(value={"/api/fileresources/{uuid}"})
    @ResponseBody
    public FileResource get(@PathVariable UUID uuid) throws HttpException {
        return (FileResource)this.service.findOne(uuid);
    }

    @GetMapping(value={"/fileresources"})
    public String list(Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        model.addAttribute("existingLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getLanguages()));
        return "fileresources/list";
    }

    @PostMapping(value={"/api/fileresources"})
    public ResponseEntity save(@RequestBody FileResource fileResource) {
        try {
            FileResource fileResourceDb = (FileResource)this.service.save((Identifiable)fileResource);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)fileResourceDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save fileresource: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/api/fileresources/type/{type}"})
    @ResponseBody
    public SearchPageResponse<FileResource> searchFileResourcesByType(@PathVariable String type, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false) String sortField, @RequestParam(name="sortDirection", required=false) Direction sortDirection, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        Sorting sorting = null;
        if (sortField != null && sortDirection != null) {
            Order order = new Order(sortDirection, sortField);
            sorting = new Sorting(new Order[]{order});
        }
        SearchPageRequest pageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize, sorting);
        return this.service.findFileResourcesByType(pageRequest, type);
    }

    @PutMapping(value={"/api/fileresources/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody FileResource fileResource) {
        try {
            FileResource fileResourceDb = (FileResource)this.service.update(uuid, (Identifiable)fileResource);
            return ResponseEntity.ok((Object)fileResourceDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save fileresource with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/fileresources/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException, ResourceNotFoundException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        FileResource resource = (FileResource)this.service.findOne(uuid);
        if (resource == null) {
            throw new ResourceNotFoundException();
        }
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)resource.getLabel().getLocales());
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("fileresource", (Object)resource);
        return "fileresources/view";
    }
}

