/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifierTypesClient;
import de.digitalcollections.model.identifiable.IdentifierType;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IdentifierTypeController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierTypeController.class);
    private final CudamiIdentifierTypesClient service;

    public IdentifierTypeController(CudamiClient client) {
        this.service = client.forIdentifierTypes();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "identifiertypes";
    }

    @GetMapping(value={"/identifiertypes/new"})
    public String create() {
        return "identifiertypes/create";
    }

    @GetMapping(value={"/api/identifiertypes/new"})
    @ResponseBody
    public IdentifierType createModel() {
        return this.service.create();
    }

    @GetMapping(value={"/identifiertypes/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) throws HttpException {
        IdentifierType identifierType = this.service.findOne(uuid);
        model.addAttribute("label", (Object)identifierType.getLabel());
        model.addAttribute("uuid", (Object)identifierType.getUuid());
        return "identifiertypes/edit";
    }

    @GetMapping(value={"/api/identifiertypes"})
    @ResponseBody
    public PageResponse<IdentifierType> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws HttpException {
        PageRequest pageRequest = new PageRequest(pageNumber, pageSize);
        return this.service.find(pageRequest);
    }

    @GetMapping(value={"/api/identifiertypes/{uuid}"})
    @ResponseBody
    public IdentifierType get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/identifiertypes"})
    public String list() {
        return "identifiertypes/list";
    }

    @PostMapping(value={"/api/identifiertypes"})
    public ResponseEntity save(@RequestBody IdentifierType identifierType) {
        try {
            IdentifierType identifierTypeDb = this.service.save(identifierType);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)identifierTypeDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save identifier type: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/identifiertypes/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody IdentifierType identifierType) {
        try {
            IdentifierType identifierTypeDb = this.service.update(uuid, identifierType);
            return ResponseEntity.ok((Object)identifierTypeDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot update identifier type with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

