/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.paging;

import de.digitalcollections.cudami.admin.paging.PageWrapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;

public class PageWrapper<T> {
    public static final int MAX_PAGE_ITEM_DISPLAY = 5;
    private final int currentNumber;
    private final List<PageItem> items;
    private final Page<T> page;
    private final long totalItems;
    private String url;

    public PageWrapper(Page<T> page, String url) {
        int size;
        int start;
        this.page = page;
        this.totalItems = page.getTotalElements();
        this.url = url;
        this.items = new ArrayList();
        this.currentNumber = page.getNumber() + 1;
        if (page.getTotalPages() <= 5) {
            start = 1;
            size = page.getTotalPages();
        } else if (this.currentNumber <= 3) {
            start = 1;
            size = 5;
        } else if (this.currentNumber >= page.getTotalPages() - 2) {
            start = page.getTotalPages() - 5 + 1;
            size = 5;
        } else {
            start = this.currentNumber - 2;
            size = 5;
        }
        for (int i = 0; i < size; ++i) {
            this.items.add(new PageItem(this, start + i, start + i == this.currentNumber));
        }
    }

    public List<T> getContent() {
        return this.page.getContent();
    }

    public List<PageItem> getItems() {
        return this.items;
    }

    public int getNumber() {
        return this.currentNumber;
    }

    public Page<T> getPage() {
        return this.page;
    }

    public int getSize() {
        return this.page.getSize();
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public int getTotalPages() {
        return this.page.getTotalPages();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isFirstPage() {
        return this.page.isFirst();
    }

    public boolean isHasNextPage() {
        return this.page.hasNext();
    }

    public boolean isHasPreviousPage() {
        return this.page.hasPrevious();
    }

    public boolean isLastPage() {
        return this.page.isLast();
    }
}

