/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiWebsitesClient;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WebsitesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsitesController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiWebsitesClient service;

    public WebsitesController(LanguageSortingHelper languageSortingHelper, CudamiClient client) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = client.forLocales();
        this.service = client.forWebsites();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "websites";
    }

    @GetMapping(value={"/websites/new"})
    public String create(Model model) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        return "websites/create";
    }

    @GetMapping(value={"/api/websites/new"})
    @ResponseBody
    public Website create() {
        return this.service.create();
    }

    @GetMapping(value={"/websites/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Website website = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)website.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("url", (Object)website.getUrl());
        model.addAttribute("uuid", (Object)website.getUuid());
        return "websites/edit";
    }

    @GetMapping(value={"/api/websites"})
    @ResponseBody
    public PageResponse<Website> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        return this.service.find(searchPageRequest);
    }

    @GetMapping(value={"/api/websites/{uuid}/webpages"})
    @ResponseBody
    public PageResponse<Webpage> findRootpages(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        return this.service.findRootPages(uuid, searchPageRequest);
    }

    @GetMapping(value={"/api/websites/{uuid}"})
    @ResponseBody
    public Website get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/websites"})
    public String list(Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        model.addAttribute("existingLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getLanguages()));
        return "websites/list";
    }

    @PostMapping(value={"/api/websites"})
    public ResponseEntity save(@RequestBody Website website) {
        try {
            Website websiteDb = this.service.save(website);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)websiteDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save website: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/websites/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Website website) {
        try {
            Website websiteDb = this.service.update(uuid, website);
            return ResponseEntity.ok((Object)websiteDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save website with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/websites/{uuid}/webpages"})
    public ResponseEntity updateRootPagesOrder(@PathVariable UUID uuid, @RequestBody List<Webpage> rootPages) throws HttpException {
        boolean successful = this.service.updateRootPagesOrder(uuid, rootPages);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/websites/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Website website = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)website.getLabel().getLocales());
        List existingWebpageLanguages = website.getRootPages().stream().flatMap(child -> child.getLabel().getLocales().stream()).collect(Collectors.toList());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("existingWebpageLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, existingWebpageLanguages));
        model.addAttribute("website", (Object)website);
        return "websites/view";
    }
}

