/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiArticlesClient;
import de.digitalcollections.model.identifiable.entity.Article;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ArticlesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArticlesController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiArticlesClient service;

    public ArticlesController(LanguageSortingHelper languageSortingHelper, CudamiClient client) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = client.forLocales();
        this.service = client.forArticles();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "articles";
    }

    @GetMapping(value={"/articles/new"})
    public String create(Model model) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        return "articles/create";
    }

    @GetMapping(value={"/api/articles/new"})
    @ResponseBody
    public Article create() {
        return this.service.create();
    }

    @GetMapping(value={"/articles/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Article article = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)article.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)article.getUuid());
        return "articles/edit";
    }

    @GetMapping(value={"/api/articles"})
    @ResponseBody
    public PageResponse<Article> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        SearchPageRequest pageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        return this.service.find(pageRequest);
    }

    @GetMapping(value={"/api/articles/{uuid}"})
    @ResponseBody
    public Article get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/articles"})
    public String list(Model model) throws HttpException {
        Locale locale = LocaleContextHolder.getLocale();
        model.addAttribute("existingLanguages", (Object)this.languageSortingHelper.sortLanguages(locale, (Collection)this.service.getLanguages()));
        return "articles/list";
    }

    @PostMapping(value={"/api/articles"})
    public ResponseEntity save(@RequestBody Article article) {
        try {
            Article articleDb = this.service.save(article);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)articleDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save article: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/articles/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Article article) {
        try {
            Article articleDb = this.service.update(uuid, article);
            return ResponseEntity.ok((Object)articleDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save article with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/articles/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Article article = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)article.getLabel().getLocales());
        model.addAttribute("article", (Object)article);
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        List relatedFileResources = this.service.getRelatedFileResources(article.getUuid());
        model.addAttribute("relatedFileResources", (Object)relatedFileResources);
        return "articles/view";
    }
}

