/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.info.InfoEndpoint;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@Order(value=1)
public class SpringConfigSecurityMonitoring
extends WebSecurityConfigurerAdapter {
    @Value(value="${management.endpoints.web.base-path}")
    private String actuatorBasePath;
    @Value(value="${spring.security.user.password}")
    private String actuatorPassword;
    @Value(value="${spring.security.user.name}")
    private String actuatorUsername;

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        ((InMemoryUserDetailsManagerConfigurer)auth.inMemoryAuthentication().passwordEncoder(this.passwordEncoderDummy())).withUser(User.withUsername((String)this.actuatorUsername).password(this.actuatorPassword).roles(new String[]{"ACTUATOR"}));
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher(this.actuatorBasePath + "/**").authorizeRequests().requestMatchers(new RequestMatcher[]{EndpointRequest.to((Class[])new Class[]{HealthEndpoint.class, InfoEndpoint.class})})).permitAll().requestMatchers(new RequestMatcher[]{EndpointRequest.to((String[])new String[]{"prometheus", "version"})})).permitAll().requestMatchers(new RequestMatcher[]{EndpointRequest.toAnyEndpoint()})).hasRole("ACTUATOR").and()).httpBasic();
    }

    private PasswordEncoder passwordEncoderDummy() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

