/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.parts;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.CudamiWebpagesClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.identifiable.entity.parts.WebpageImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WebpagesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpagesController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiWebpagesClient service;

    @Autowired
    public WebpagesController(LanguageSortingHelper languageSortingHelper, CudamiClient cudamiClient) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = cudamiClient.forLocales();
        this.service = cudamiClient.forWebpages();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "webpages";
    }

    @GetMapping(value={"/webpages/new"})
    public String create(Model model, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") String parentUuid) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "webpages/create";
    }

    @GetMapping(value={"/api/webpages/new"})
    @ResponseBody
    public Webpage create() {
        return this.service.create();
    }

    @GetMapping(value={"/webpages/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Webpage webpage = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)webpage.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)webpage.getUuid());
        return "webpages/edit";
    }

    @GetMapping(value={"/api/webpages/{uuid}"})
    @ResponseBody
    public Webpage get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/api/webpages/{uuid}/webpages"})
    @ResponseBody
    public PageResponse<WebpageImpl> getSubpages(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws HttpException {
        return this.service.getChildren(uuid, (PageRequest)new PageRequestImpl(pageNumber, pageSize));
    }

    @PostMapping(value={"/api/webpages/new"})
    public ResponseEntity save(@RequestBody Webpage webpage, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") UUID parentUuid) {
        try {
            Webpage webpageDb = null;
            webpageDb = parentType.equals("website") ? this.service.saveWithParentWebsite(webpage, parentUuid) : this.service.saveWithParentWebpage(webpage, parentUuid);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)webpageDb);
        }
        catch (HttpException e) {
            if (parentType.equals("website")) {
                LOGGER.error("Cannot save top-level webpage: ", (Throwable)e);
            } else if (parentType.equals("webpage")) {
                LOGGER.error("Cannot save webpage: ", (Throwable)e);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/webpages/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Webpage webpage) {
        try {
            Webpage webpageDb = this.service.update(uuid, webpage);
            return ResponseEntity.ok((Object)webpageDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save webpage with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/webpages/{uuid}/webpages"})
    public ResponseEntity updateSubpagesOrder(@PathVariable UUID uuid, @RequestBody List<Webpage> subpages) throws HttpException {
        boolean successful = this.service.updateChildrenOrder(uuid, subpages);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/webpages/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Webpage webpage = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)webpage.getLabel().getLocales());
        List existingSubpageLanguages = webpage.getChildren().stream().flatMap(child -> child.getLabel().getLocales().stream()).collect(Collectors.toList());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("existingSubpageLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, existingSubpageLanguages));
        model.addAttribute("webpage", (Object)webpage);
        List relatedFileResources = this.service.getRelatedFileResources(uuid);
        model.addAttribute("relatedFileResources", (Object)relatedFileResources);
        BreadcrumbNavigation breadcrumbNavigation = this.service.getBreadcrumbNavigation(uuid);
        List breadcrumbs = breadcrumbNavigation.getNavigationItems();
        breadcrumbs.removeIf(n -> n.getUuid() == null);
        model.addAttribute("breadcrumbs", (Object)breadcrumbs);
        Website website = this.service.getWebsite(uuid);
        model.addAttribute("website", (Object)website);
        return "webpages/view";
    }
}

