/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.view;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.cudami.client.view.CudamiRenderingTemplatesClient;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import de.digitalcollections.model.impl.view.RenderingTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RenderingTemplatesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderingTemplatesController.class);
    private final CudamiLocalesClient localeService;
    private final CudamiRenderingTemplatesClient service;

    public RenderingTemplatesController(CudamiClient cudamiClient) {
        this.localeService = cudamiClient.forLocales();
        this.service = cudamiClient.forRenderingTemplates();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "renderingTemplates";
    }

    @GetMapping(value={"/renderingtemplates/new"})
    public String create() {
        return "renderingtemplates/create";
    }

    @GetMapping(value={"/api/renderingtemplates/new"})
    @ResponseBody
    public RenderingTemplate createModel() {
        return this.service.create();
    }

    @GetMapping(value={"/renderingtemplates/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) throws HttpException {
        RenderingTemplate template = this.service.findOne(uuid);
        model.addAttribute("name", (Object)template.getName());
        model.addAttribute("uuid", (Object)template.getUuid());
        return "renderingtemplates/edit";
    }

    @GetMapping(value={"/api/renderingtemplates"})
    @ResponseBody
    public PageResponse<RenderingTemplate> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws HttpException {
        ArrayList<OrderImpl> orders = new ArrayList<OrderImpl>();
        OrderImpl labelOrder = new OrderImpl("label");
        labelOrder.setSubProperty(this.localeService.getDefaultLanguage().getLanguage());
        orders.addAll(Arrays.asList(labelOrder, new OrderImpl("name")));
        SortingImpl sorting = new SortingImpl(orders);
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, (Sorting)sorting);
        return this.service.find((PageRequest)pageRequest);
    }

    @GetMapping(value={"/api/renderingtemplates/{uuid}"})
    @ResponseBody
    public RenderingTemplate get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/renderingtemplates"})
    public String list() {
        return "renderingtemplates/list";
    }

    @PostMapping(value={"/api/renderingtemplates/new"})
    public ResponseEntity save(@RequestBody RenderingTemplate template) {
        try {
            RenderingTemplate templateDb = this.service.save(template);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)templateDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save rendering template: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/renderingtemplates/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody RenderingTemplate template) {
        try {
            RenderingTemplate templateDb = this.service.update(uuid, template);
            return ResponseEntity.ok((Object)templateDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot update rendering template with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

