/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.resource;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiFileResourcesMetadataClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.SearchPageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class FileResourcesMetadataController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourcesMetadataController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiFileResourcesMetadataClient service;

    @Autowired
    public FileResourcesMetadataController(LanguageSortingHelper languageSortingHelper, CudamiClient cudamiClient) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = cudamiClient.forLocales();
        this.service = cudamiClient.forFileResourcesMetadata();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "fileresources";
    }

    @GetMapping(value={"/fileresources/new"})
    public String create(Model model) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        return "fileresources/create";
    }

    @GetMapping(value={"/api/fileresources/new"})
    @ResponseBody
    public FileResource create() {
        return this.service.create();
    }

    @GetMapping(value={"/fileresources/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        FileResource fileResource = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)fileResource.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("filename", (Object)fileResource.getFilename());
        model.addAttribute("uuid", (Object)fileResource.getUuid());
        return "fileresources/edit";
    }

    @GetMapping(value={"/api/fileresources/{uuid}"})
    @ResponseBody
    public FileResource get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/fileresources"})
    public String list(Model model, @PageableDefault(sort={"filename"}, direction=Sort.Direction.ASC, size=25) Pageable pageable) throws HttpException {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.service.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/fileresources"));
        return "fileresources/list";
    }

    @PostMapping(value={"/api/fileresources/new"})
    public ResponseEntity save(@RequestBody FileResource fileResource) {
        try {
            FileResource fileResourceDb = this.service.save(fileResource);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)fileResourceDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save fileresource: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/api/fileresources/type/{type}"})
    @ResponseBody
    public SearchPageResponse<FileResourceImpl> searchFileResourcesByType(@PathVariable String type, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false) String sortField, @RequestParam(name="sortDirection", required=false) Direction sortDirection, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        SortingImpl sorting = null;
        if (sortField != null && sortDirection != null) {
            OrderImpl order = new OrderImpl(sortDirection, sortField);
            sorting = new SortingImpl(new Order[]{order});
        }
        SearchPageRequestImpl pageRequest = new SearchPageRequestImpl(searchTerm, pageNumber, pageSize, sorting);
        return this.service.findFileResourcesByType((SearchPageRequest)pageRequest, type);
    }

    @PutMapping(value={"/api/fileresources/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody FileResource fileResource) {
        try {
            FileResource fileResourceDb = this.service.update(uuid, fileResource);
            return ResponseEntity.ok((Object)fileResourceDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save fileresource with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/fileresources/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        FileResource resource = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)resource.getLabel().getLocales());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("fileresource", (Object)resource);
        return "fileresources/view";
    }
}

