/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiDigitalObjectsClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.impl.identifiable.entity.DigitalObjectImpl;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SearchPageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DigitalObjectsController
extends AbstractController {
    private final CudamiDigitalObjectsClient service;

    @Autowired
    public DigitalObjectsController(CudamiClient client) {
        this.service = client.forDigitalObjects();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "digitalobjects";
    }

    @GetMapping(value={"/api/digitalobjects/identifier/{namespace}:{id}"})
    @ResponseBody
    public DigitalObject findOneByIdentifier(@PathVariable String namespace, @PathVariable String id) throws HttpException {
        return this.service.findOneByIdentifier(namespace, id);
    }

    @GetMapping(value={"/digitalobjects"})
    public String list(Model model, @PageableDefault(size=25) Pageable pageable) throws HttpException {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.service.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/digitalobjects"));
        return "digitalobjects/list";
    }

    @GetMapping(value={"/api/digitalobjects/search"})
    @ResponseBody
    public SearchPageResponse<DigitalObjectImpl> search(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false) String sortField, @RequestParam(name="sortDirection", required=false) Direction sortDirection, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        SortingImpl sorting = null;
        if (sortField != null && sortDirection != null) {
            OrderImpl order = new OrderImpl(sortDirection, sortField);
            sorting = new SortingImpl(new Order[]{order});
        }
        SearchPageRequestImpl pageRequest = new SearchPageRequestImpl(searchTerm, pageNumber, pageSize, sorting);
        return this.service.find((SearchPageRequest)pageRequest);
    }

    @GetMapping(value={"/digitalobjects/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        DigitalObject digitalObject = this.service.findOne(uuid);
        model.addAttribute("digitalObject", (Object)digitalObject);
        PageResponse pageResponseCollections = this.service.getCollections(uuid, (PageRequest)new PageRequestImpl(0, 100));
        List collections = pageResponseCollections.getContent();
        model.addAttribute("collections", (Object)collections);
        PageResponse pageResponseProjects = this.service.getProjects(uuid, (PageRequest)new PageRequestImpl(0, 100));
        List projects = pageResponseProjects.getContent();
        model.addAttribute("projects", (Object)projects);
        return "digitalobjects/view";
    }
}

