/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.CudamiProjectsClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.Project;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ProjectsController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectsController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiProjectsClient service;

    @Autowired
    public ProjectsController(LanguageSortingHelper languageSortingHelper, CudamiClient cudamiClient) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = cudamiClient.forLocales();
        this.service = cudamiClient.forProjects();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "projects";
    }

    @PostMapping(value={"/api/projects/{uuid}/digitalobjects"})
    public ResponseEntity addDigitalObjects(@PathVariable UUID uuid, @RequestBody List<DigitalObject> digitalObjects) throws HttpException {
        boolean successful = this.service.addDigitalObjects(uuid, digitalObjects);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/projects/new"})
    public String create(Model model) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        return "projects/create";
    }

    @GetMapping(value={"/api/projects/new"})
    @ResponseBody
    public Project create() {
        return this.service.create();
    }

    @GetMapping(value={"/projects/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Project project = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)project.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)project.getUuid());
        return "projects/edit";
    }

    @GetMapping(value={"/api/projects/{uuid}"})
    @ResponseBody
    public Project get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/api/projects/{uuid}/digitalobjects"})
    @ResponseBody
    public PageResponse<DigitalObject> getDigitalObjects(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws HttpException {
        PageRequestImpl pageRequest = new PageRequestImpl();
        pageRequest.setPageNumber(pageNumber);
        pageRequest.setPageSize(pageSize);
        return this.service.getDigitalObjects(uuid, (PageRequest)pageRequest);
    }

    @GetMapping(value={"/projects"})
    public String list(Model model, @PageableDefault(sort={"lastModified"}, direction=Sort.Direction.DESC, size=25) Pageable pageable) throws HttpException {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.service.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/projects"));
        return "projects/list";
    }

    @DeleteMapping(value={"/api/projects/{projectUuid}/digitalobjects/{digitalobjectUuid}"})
    @ResponseBody
    public ResponseEntity removeDigitalObject(@PathVariable UUID projectUuid, @PathVariable UUID digitalobjectUuid) throws HttpException {
        boolean successful = this.service.removeDigitalObject(projectUuid, digitalobjectUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/projects/new"})
    public ResponseEntity save(@RequestBody Project project) {
        try {
            Project projectDb = this.service.save(project);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)projectDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save project: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/projects/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Project project) {
        try {
            Project projectDb = this.service.update(uuid, project);
            return ResponseEntity.ok((Object)projectDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save project with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/projects/{uuid}"})
    public String view(@PathVariable UUID uuid, @PageableDefault(size=25) Pageable pageable, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Project project = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)project.getLabel().getLocales());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("project", (Object)project);
        return "projects/view";
    }
}

