/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.parts;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.parts.WebpageService;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.identifiable.entity.parts.EntityPart;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WebpagesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpagesController.class);
    LanguageSortingHelper languageSortingHelper;
    LocaleRepository localeRepository;
    WebpageService service;

    @Autowired
    public WebpagesController(LanguageSortingHelper languageSortingHelper, LocaleRepository localeRepository, WebpageService service) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeRepository = localeRepository;
        this.service = service;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "webpages";
    }

    @GetMapping(value={"/webpages/new"})
    public String create(Model model, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") String parentUuid) {
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "webpages/create";
    }

    @GetMapping(value={"/api/webpages/new"})
    @ResponseBody
    public Webpage create() {
        return (Webpage)this.service.create();
    }

    @GetMapping(value={"/webpages/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Webpage webpage = (Webpage)this.service.get(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, webpage.getLabel().getLocales());
        model.addAttribute("activeLanguage", existingLanguages.get(0));
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)webpage.getUuid());
        return "webpages/edit";
    }

    @GetMapping(value={"/api/webpages/{uuid}"})
    @ResponseBody
    public Webpage get(@PathVariable UUID uuid) {
        return (Webpage)this.service.get(uuid);
    }

    @PostMapping(value={"/api/webpages/new"})
    public ResponseEntity save(@RequestBody Webpage webpage, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") UUID parentUuid) throws IdentifiableServiceException {
        try {
            Webpage webpageDb = null;
            webpageDb = parentType.equals("website") ? this.service.saveWithParentWebsite(webpage, parentUuid) : this.service.saveWithParentWebpage(webpage, parentUuid);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)webpageDb);
        }
        catch (Exception e) {
            if (parentType.equals("website")) {
                LOGGER.error("Cannot save top-level webpage: ", (Throwable)e);
            } else if (parentType.equals("webpage")) {
                LOGGER.error("Cannot save webpage: ", (Throwable)e);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/webpages/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Webpage webpage) throws IdentifiableServiceException {
        try {
            Webpage webpageDb = (Webpage)this.service.update((Identifiable)webpage);
            return ResponseEntity.ok((Object)webpageDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save webpage with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/webpages/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Webpage webpage = (Webpage)this.service.get(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, webpage.getLabel().getLocales());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("webpage", (Object)webpage);
        List relatedFileResources = this.service.getRelatedFileResources((EntityPart)webpage);
        model.addAttribute("relatedFileResources", (Object)relatedFileResources);
        ArrayList breadcrumbs = new ArrayList();
        this.addParentNodeToBreadcrumb((Node)webpage, breadcrumbs);
        Collections.reverse(breadcrumbs);
        model.addAttribute("breadcrumbs", breadcrumbs);
        Website website = this.service.getWebsite(uuid);
        model.addAttribute("website", (Object)website);
        return "webpages/view";
    }

    private void addParentNodeToBreadcrumb(Node currentWebpage, List<Node> breadcrumbs) {
        Node parent = this.service.getParent(currentWebpage);
        if (parent != null && parent.getUuid() != null) {
            breadcrumbs.add(parent);
            this.addParentNodeToBreadcrumb(parent, breadcrumbs);
        }
    }
}

